/*
 * Decompiled with CFR 0.152.
 */
package contato.controller.listfocus;

import contato.controller.listfocus.DialogListPaginationListener;
import contato.swing.ContatoList;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class DialogListFocusController
implements KeyListener {
    private ContatoList list;
    private JTextField textField;
    private Integer index = -1;
    private DialogListPaginationListener dialogListPaginationListener;

    private DialogListFocusController() {
    }

    private DialogListFocusController(ContatoList list, JTextField textField) {
        this.list = list;
        this.textField = textField;
        if (this.list != null) {
            this.list.setFocusable(false);
        }
    }

    private DialogListFocusController(ContatoList list, JTextField textField, DialogListPaginationListener dialogListPaginationListener) {
        this.list = list;
        this.textField = textField;
        this.dialogListPaginationListener = dialogListPaginationListener;
        if (this.list != null) {
            this.list.setFocusable(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 40) {
            this.processDownAction();
        } else if (e.getKeyCode() == 38) {
            this.processUpAction();
        }
    }

    public static DialogListFocusController buildInstance(ContatoList list, JTextField textField) {
        return new DialogListFocusController(list, textField);
    }

    public static DialogListFocusController buildInstance(ContatoList list, JTextField textField, DialogListPaginationListener dialogListPaginationListener) {
        return new DialogListFocusController(list, textField, dialogListPaginationListener);
    }

    public void updateList(ContatoList list) {
        this.list = list;
        this.index = -1;
        if (list != null) {
            list.setFocusable(false);
        }
    }

    public void processDownAction() {
        if (this.list != null && this.textField != null) {
            if (this.index + 1 < this.list.getModel().getSize()) {
                this.index = this.index + 1;
                this.list.setSelectedIndex(this.index);
                this.list.setSelectedValue(this.list.getModel().getElementAt(this.index), true);
            } else if (this.dialogListPaginationListener != null) {
                this.dialogListPaginationListener.requestMoreObjects(this.index, this.textField);
            }
        }
    }

    public void processUpAction() {
        if (this.list != null && this.textField != null && this.index - 1 <= this.list.getModel().getSize() && this.index - 1 > -1) {
            this.index = this.index - 1;
            this.list.setSelectedIndex(this.index);
        }
    }
}

