/*
 * Decompiled with CFR 0.152.
 */
package contato.finder.annotations;

import contatocore.anotations.queryfieldfinder.QueryClassFinder;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class AnnotationUtil {
    private BeanInfo beanInfo;
    private String beanName;
    private static final int READ_METHODS_ONLY = 0;
    private static final int WRITE_METHODS_ONLY = 1;
    private static final int BOTH_METHODS = 2;

    public AnnotationUtil(Class beanClass) throws IntrospectionException {
        this.beanInfo = Introspector.getBeanInfo(beanClass);
        MethodDescriptor[] m = this.beanInfo.getMethodDescriptors();
        MethodDescriptor d = m[0];
        QueryClassFinder q = beanClass.getAnnotation(QueryClassFinder.class);
        if (q != null) {
            this.beanName = q.name() != null ? q.name() : "";
        }
    }

    public String getName() {
        return this.beanName;
    }

    public Method[] getAnnotatedBeanReadMethods(Class annotationClass) {
        return this.getAnnotatedMethods(this.getReadMethods(), annotationClass);
    }

    public Method[] getAnnotatedBeanWriteMethods(Class annotationClass) {
        return this.getAnnotatedMethods(this.getSetMethods(), annotationClass);
    }

    public Method[] getAnnotatedBeanReadWriteMethods(Class annotationClass) {
        return this.getAnnotatedMethods(this.getReadWriteMethods(), annotationClass);
    }

    private Method[] getAnnotatedMethods(Method[] methods, Class annotationClass) {
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method m : methods) {
            Object obj;
            if (m == null || (obj = m.getAnnotation(annotationClass)) == null) continue;
            annotatedMethods.add(m);
        }
        return annotatedMethods.toArray(new Method[annotatedMethods.size()]);
    }

    private Method[] getReadWriteMethods() {
        return this.getMethods(2);
    }

    private Method[] getSetMethods() {
        return this.getMethods(1);
    }

    private Method[] getReadMethods() {
        return this.getMethods(0);
    }

    private Method[] getMethods(int type) {
        PropertyDescriptor[] props;
        ArrayList<Method> methods = new ArrayList<Method>();
        block5: for (PropertyDescriptor p : props = this.beanInfo.getPropertyDescriptors()) {
            switch (type) {
                case 0: {
                    methods.add(p.getReadMethod());
                    continue block5;
                }
                case 1: {
                    methods.add(p.getWriteMethod());
                    continue block5;
                }
                case 2: {
                    methods.add(p.getReadMethod());
                    methods.add(p.getWriteMethod());
                    continue block5;
                }
            }
        }
        return methods.toArray(new Method[methods.size()]);
    }
}

