/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.interfaces.ContatoComponent30x30Size;
import contato.interfaces.ContatoControllerComponent;
import java.awt.AWTKeyStroke;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JButton;

public class ContatoButton
extends JButton
implements ContatoControllerComponent,
ContatoComponent30x30Size {
    public ContatoButton() {
        this.initEventMouse();
        this.setReadWrite();
        this.setFocusable(false);
        this.setTabFocusLost();
    }

    public ContatoButton(String text) {
        super(text);
        this.initEventMouse();
        this.setReadWrite();
        this.setFocusable(false);
        this.setTabFocusLost();
    }

    private void initEventMouse() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ContatoButton.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ContatoButton.this.setCursor(new Cursor(0));
            }
        });
    }

    @Override
    public String getToolTipText() {
        String text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = text + "<html><b>" + super.getToolTipText();
            text = text + "</b>" + (this.getText() != null && this.getText().trim().length() > 0 ? "<br>" + this.getText() : "");
            text = text + "</html>";
        }
        return text;
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    private void setTabFocusLost() {
        HashSet<AWTKeyStroke> conj = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        conj.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        this.setFocusTraversalKeys(0, conj);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        Dimension d = this.checkMinimunDimension(preferredSize);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        Dimension d = this.checkMinimunDimension(minimumSize);
        super.setMinimumSize(d);
    }

    private Dimension checkMinimunDimension(Dimension d) {
        int height = d.height;
        int width = d.width;
        if (height < MIN_HEIGHT) {
            height = MIN_HEIGHT;
        }
        if (width < MIN_WIDHT) {
            width = MIN_WIDHT;
        }
        return new Dimension(width, height);
    }
}

