/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.touchcomp.basementormedia.ImageProviderFact;
import contato.dialog.ContatoDialogsHelper;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ContatoButton;
import contato.swing.ContatoCheckBox;
import contato.util.contatofilechooser.ContatoFileChooserUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ContatoBytesFromFileFrame
extends JPanel
implements ContatoControllerComponent,
ContatoClearComponent {
    private byte[] dados;
    private ContatoButton btnCarregar;
    private ContatoButton btnLimpar;
    private ContatoCheckBox chcDadosCarregados;

    public ContatoBytesFromFileFrame() {
        this.initComponents();
        this.chcDadosCarregados.setReadOnly();
    }

    private void initComponents() {
        this.btnLimpar = new ContatoButton();
        this.chcDadosCarregados = new ContatoCheckBox();
        this.btnCarregar = new ContatoButton();
        this.setLayout(new GridBagLayout());
        this.btnLimpar.setIcon(new ImageIcon(ImageProviderFact.get().getImageDelete()));
        this.btnLimpar.setText("Limpar");
        this.btnLimpar.setMinimumSize(new Dimension(110, 20));
        this.btnLimpar.setPreferredSize(new Dimension(110, 20));
        this.btnLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContatoBytesFromFileFrame.this.btnLimparActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.btnLimpar, gridBagConstraints);
        this.chcDadosCarregados.setText("Dados carregados");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.chcDadosCarregados, gridBagConstraints);
        this.btnCarregar.setIcon(new ImageIcon(ImageProviderFact.get().getImageFind()));
        this.btnCarregar.setText("Carregar");
        this.btnCarregar.setMinimumSize(new Dimension(110, 20));
        this.btnCarregar.setPreferredSize(new Dimension(110, 20));
        this.btnCarregar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContatoBytesFromFileFrame.this.btnCarregarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.btnCarregar, gridBagConstraints);
    }

    private void btnLimparActionPerformed(ActionEvent evt) {
        this.setDados(null);
        this.chcDadosCarregados.setSelected(false);
    }

    private void btnCarregarActionPerformed(ActionEvent evt) {
        try {
            File f = ContatoFileChooserUtilities.getFileToLoad();
            if (f != null) {
                this.setDados(ContatoFileChooserUtilities.getBytesOfFile(f.getAbsolutePath()));
                this.chcDadosCarregados.setSelected(true);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContatoBytesFromFileFrame.class.getName()).log(Level.SEVERE, null, ex);
            ContatoDialogsHelper.showError("Erro ao acessar o arquivo.");
        }
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    @Override
    public void clear() {
        this.setDados(null);
        this.chcDadosCarregados.clear();
    }

    public byte[] getDados() {
        return this.dados;
    }

    public void setDados(byte[] dados) {
        this.dados = dados;
    }

    public void currentObjectToScreen() {
        if (this.dados != null) {
            this.chcDadosCarregados.setSelected(true);
        }
    }
}

