/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoCNPJException;
import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoCepTextField;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoFormatterUtil;
import contatocore.util.ContatoIsValid;
import contatocore.util.ContatoStringUtil;
import java.awt.Dimension;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoCNPJTextField
extends ContatoFormattedTextField {
    public ContatoCNPJTextField() {
        this.setValue(null);
        this.setHorizontalAlignment(0);
        this.setPreferredSize(new Dimension(150, 18));
        this.setMinimumSize(new Dimension(150, 18));
        this.setFormatterFactory(ContatoFormatterUtil.getCNPJMask());
    }

    public String getValidValue() throws ContatoCNPJException {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null && !ContatoIsValid.testCPFCNPJ((String)value)) {
            throw new ContatoCNPJException();
        }
        return ContatoStringUtil.refina((String)this.getValue());
    }

    @Override
    public String getString() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCepTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ContatoStringUtil.refina((String)this.getValue());
    }

    @Override
    public Object getValue() {
        return ContatoStringUtil.refina((String)super.getValue());
    }
}

