/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoCPFException;
import contato.swing.ContatoCepTextField;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoIsValid;
import contatocore.util.ContatoMaskFactory;
import contatocore.util.ContatoStringUtil;
import java.awt.Dimension;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoCPFTextField
extends ContatoFormattedTextField {
    public ContatoCPFTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getMaskCPF());
        this.setHorizontalAlignment(0);
        this.setPreferredSize(new Dimension(130, 18));
        this.setMinimumSize(new Dimension(130, 18));
    }

    public boolean validar() throws ContatoCPFException {
        Object value = this.getValue();
        if (value != null) {
            if (!ContatoIsValid.testCPFCNPJ((String)value)) {
                throw new ContatoCPFException("CPF inv\u00e1lido!");
            }
            return true;
        }
        return false;
    }

    public String getValidValue() throws ContatoCPFException {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null && !ContatoIsValid.testCPFCNPJ((String)value)) {
            throw new ContatoCPFException();
        }
        return ContatoStringUtil.refina((String)this.getValue());
    }

    @Override
    public String getString() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCepTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ContatoStringUtil.refina((String)this.getValue());
    }

    @Override
    public void commitEdit() throws ParseException {
        super.commitEdit();
    }
}

