/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoCEPException;
import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoIsValid;
import contatocore.util.ContatoMaskFactory;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoCepTextField
extends ContatoFormattedTextField {
    public ContatoCepTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getMaskCEP());
        this.setHorizontalAlignment(0);
    }

    public String getValidObject() throws ContatoCEPException {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null && !ContatoIsValid.testCep((String)value)) {
            throw new ContatoCEPException();
        }
        return (String)value;
    }

    public boolean validar() throws ContatoCEPException {
        Object value = this.getValue();
        if (value != null) {
            if (!ContatoIsValid.testCep((String)value)) {
                throw new ContatoCEPException("CEP inv\u00e1lido!");
            }
            return true;
        }
        return false;
    }

    @Override
    public String getString() {
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (String)this.getValue();
    }
}

