/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.alee.extended.date.DateSelectionListener;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateField;
import com.alee.extended.date.WebDateFieldStyle;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.text.WebFormattedTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.settings.SettingsMethods;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.Customizer;
import com.alee.utils.swing.SizeMethods;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoComponent120x30Size;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ColorFocus;
import contato.swing.ContatoDateTimeTextField;
import contatocore.util.ContatoMaskFactory;
import contatocore.util.ContatoStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.DefaultFormatterFactory;

public class ContatoDateTextField
extends WebFormattedTextField
implements ShapeProvider,
SettingsMethods,
SizeMethods<WebFormattedTextField>,
ContatoControllerComponent,
ContatoClearComponent,
ColorFocus,
ContatoComponent120x30Size {
    private boolean selectAllOnFocusGained = true;
    Color def = null;
    public static final ImageIcon selectDateIcon = new ImageIcon(WebDateField.class.getResource("icons/date.png"));
    protected List<DateSelectionListener> dateSelectionListeners = new ArrayList<DateSelectionListener>(1);
    protected boolean fireSelectionWithoutChanges = true;
    protected SimpleDateFormat dateFormat;
    protected Date date = null;
    protected Customizer<WebCalendar> calendarCustomizer = null;
    protected WebButton popupButton;
    protected WebWindow popup;
    protected WebCalendar calendar;
    protected DateSelectionListener dateSelectionListener;

    public ContatoDateTextField() {
        this.setReadWrite();
        this.setHorizontalAlignment(0);
        this.setSize(new Dimension(MIN_WIDHT, MIN_HEIGHT));
        this.setPreferredSize(new Dimension(MIN_WIDHT, MIN_HEIGHT));
        this.setMinimumSize(new Dimension(MIN_WIDHT, MIN_HEIGHT));
        this.buildFormatter(new SimpleDateFormat("dd/MM/yyyy"), ContatoMaskFactory.getMaskDate("##/##/####"));
        this.setOpaque(false);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawBackground(WebDateFieldStyle.drawBackground);
        this.setBackground(WebDateFieldStyle.backgroundColor);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawFocus(WebDateFieldStyle.drawFocus);
        this.popupButton = WebButton.createIconWebButton((ImageIcon)selectDateIcon, (int)WebDateFieldStyle.round);
        this.popupButton.setFocusable(false);
        this.popupButton.setShadeWidth(0);
        this.popupButton.setMoveIconOnPress(false);
        this.popupButton.setRolloverDecoratedOnly(true);
        this.popupButton.setCursor(Cursor.getDefaultCursor());
        this.popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContatoDateTextField.this.isEditable() && ContatoDateTextField.this.isEnabled()) {
                    ContatoDateTextField.this.showCalendarPopup();
                }
            }
        });
        this.setTrailingComponent((JComponent)this.popupButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContatoDateTextField.this.setDateFromField(true);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ContatoDateTextField.this.isEditable() && ContatoDateTextField.this.isEnabled() && SwingUtilities.isRightMouseButton(e)) {
                    ContatoDateTextField.this.showCalendarPopup();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!SwingUtils.isEqualOrChild((Component)ContatoDateTextField.this.popup, (Component)e.getOppositeComponent())) {
                    ContatoDateTextField.this.setDateFromField(true);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (ContatoDateTextField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(e)) {
                        ContatoDateTextField.this.updateFieldFromDate();
                    } else if (Hotkey.DOWN.isTriggered(e)) {
                        ContatoDateTextField.this.showCalendarPopup();
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ContatoDateTextField.this.hideCalendarPopup();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ContatoDateTextField.this.hideCalendarPopup();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ContatoDateTextField.this.hideCalendarPopup();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ContatoDateTextField.this.hideCalendarPopup();
            }
        });
        this.updateFieldFromDate();
        this.setRound(WebDateFieldStyle.round);
        this.setShadeWidth(WebDateFieldStyle.shadeWidth);
    }

    public ContatoDateTextField(boolean drawBorder) {
        this(null, drawBorder);
    }

    public ContatoDateTextField(Date date) {
        this(date, WebDateFieldStyle.drawBorder);
    }

    public ContatoDateTextField(Date date, boolean drawBorder) {
        this.date = date;
        this.setDate(date);
        this.setDrawBorder(drawBorder);
    }

    public WebButton getPopupButton() {
        return this.popupButton;
    }

    public void setRound(int round) {
        super.setRound(round);
        this.popupButton.setRound(round);
    }

    public void setDrawBorder(boolean drawBorder) {
        super.setDrawBorder(drawBorder);
        this.updateMargin();
    }

    public Customizer<WebCalendar> getCalendarCustomizer() {
        return this.calendarCustomizer;
    }

    public void setCalendarCustomizer(Customizer<WebCalendar> customizer) {
        this.calendarCustomizer = customizer;
        if (customizer != null && this.calendar != null) {
            customizer.customize((Object)this.calendar);
        }
    }

    protected void updateMargin() {
        this.setMargin(this.isDrawBorder() ? WebDateFieldStyle.margin : WebDateFieldStyle.undecoratedMargin);
    }

    protected void showCalendarPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.setDateFromField(false);
        if (this.popup == null || this.calendar == null) {
            Window ancestor = SwingUtils.getWindowAncestor((Component)((Object)this));
            this.calendar = new WebCalendar(this.date);
            this.calendar.setPaintFocus(false);
            this.calendar.setRound(StyleConstants.smallRound);
            this.calendar.setShadeWidth(0);
            if (this.calendarCustomizer != null) {
                this.calendarCustomizer.customize((Object)this.calendar);
            }
            this.popup = new WebWindow(ancestor);
            this.popup.setLayout((LayoutManager)new BorderLayout());
            this.popup.setCloseOnFocusLoss(true);
            this.popup.setWindowOpaque(false);
            this.popup.add((Component)this.calendar);
            this.customizePopup(this.popup);
            this.popup.pack();
            this.updatePopupLocation();
            ancestor.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ContatoDateTextField.this.popup.isShowing()) {
                        ContatoDateTextField.this.updatePopupLocation();
                    }
                }
            });
            this.dateSelectionListener = new DateSelectionListener(){

                public void dateSelected(Date date) {
                    ContatoDateTextField.this.hideCalendarPopup();
                    ContatoDateTextField.this.setDateFromCalendar(true);
                    ContatoDateTextField.this.requestFocusInWindow();
                    ContatoDateTextField.this.processStrDate();
                }
            };
            this.calendar.addDateSelectionListener(this.dateSelectionListener);
        } else {
            this.updatePopupLocation();
        }
        SwingUtils.copyOrientation((Component)((Object)this), (Component)this.popup);
        this.popup.setVisible(true);
        this.calendar.transferFocus();
    }

    protected void customizePopup(WebWindow popup) {
    }

    protected void hideCalendarPopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    protected void updatePopupLocation() {
        Point los = this.getLocationOnScreen();
        Rectangle gb = this.popup.getGraphicsConfiguration().getBounds();
        int shadeWidth = this.isDrawBorder() ? this.getShadeWidth() : 0;
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = ltr ? (los.x + shadeWidth + this.popup.getWidth() <= gb.x + gb.width ? los.x + shadeWidth : los.x + w - shadeWidth - this.popup.getWidth()) : (los.x + w - shadeWidth - this.popup.getWidth() >= gb.x ? los.x + w - shadeWidth - this.popup.getWidth() : los.x + shadeWidth);
        int y = los.y + h + this.popup.getHeight() <= gb.y + gb.height ? los.y + h + (this.isDrawBorder() ? 0 : 1) : los.y - this.popup.getHeight() - (this.isDrawBorder() ? 0 : 1);
        this.popup.setLocation(x, y);
    }

    protected Date getDateFromField() {
        try {
            return this.processStrDate();
        }
        catch (Throwable ex) {
            return this.date;
        }
    }

    protected String getTextDate() {
        return this.date != null ? this.dateFormat.format(this.date) : "";
    }

    public Date getDate() {
        this.processStrDate();
        return this.date;
    }

    public void setDate(Date date) {
        this.setDateImpl(date, UpdateSource.other, true);
    }

    public void updateDateFromField(boolean fireEvent) {
        this.setDateFromField(fireEvent);
    }

    protected void setDateFromField(boolean fireEvent) {
        this.setDateImpl(this.getDateFromField(), UpdateSource.field, fireEvent);
    }

    protected void setDateFromCalendar(boolean fireEvent) {
        this.setDateImpl(this.calendar.getDate(), UpdateSource.calendar, fireEvent);
    }

    protected void setDateImpl(Date date, UpdateSource source, boolean fireEvent) {
        boolean changed = !CompareUtils.equals((Object)this.date, (Object[])new Object[]{date});
        this.date = date;
        if (date == null) {
            super.setValue((Object)date);
        }
        this.updateFieldFromDate();
        if (this.fireSelectionWithoutChanges || changed) {
            if (source != UpdateSource.calendar && this.calendar != null) {
                this.updateCalendarFromDate(date);
            }
            if (fireEvent) {
                this.fireDateSelected(date);
            }
        }
    }

    protected void updateFieldFromDate() {
        this.setText(this.getTextDate());
        this.setCaretPosition(0);
    }

    protected void updateCalendarFromDate(Date date) {
        this.calendar.removeDateSelectionListener(this.dateSelectionListener);
        this.calendar.setDate(date);
        this.calendar.addDateSelectionListener(this.dateSelectionListener);
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.updateFieldFromDate();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.popupButton.setEnabled(enabled);
    }

    public boolean isFireSelectionWithoutChanges() {
        return this.fireSelectionWithoutChanges;
    }

    public void setFireSelectionWithoutChanges(boolean fire) {
        this.fireSelectionWithoutChanges = fire;
    }

    public void addDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.add(listener);
    }

    public void removeDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.remove(listener);
    }

    public void fireDateSelected(Date date) {
        for (DateSelectionListener listener : CollectionUtils.copy(this.dateSelectionListeners)) {
            listener.dateSelected(date);
        }
    }

    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth((Component)((Object)this));
    }

    public ContatoDateTextField setPreferredWidth(int preferredWidth) {
        return (ContatoDateTextField)((Object)SizeUtils.setPreferredWidth((Component)((Object)this), (int)preferredWidth));
    }

    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight((Component)((Object)this));
    }

    public ContatoDateTextField setPreferredHeight(int preferredHeight) {
        return (ContatoDateTextField)((Object)SizeUtils.setPreferredHeight((Component)((Object)this), (int)preferredHeight));
    }

    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth((Component)((Object)this));
    }

    public ContatoDateTextField setMinimumWidth(int minimumWidth) {
        return (ContatoDateTextField)((Object)SizeUtils.setMinimumWidth((Component)((Object)this), (int)minimumWidth));
    }

    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight((Component)((Object)this));
    }

    public ContatoDateTextField setMinimumHeight(int minimumHeight) {
        return (ContatoDateTextField)((Object)SizeUtils.setMinimumHeight((Component)((Object)this), (int)minimumHeight));
    }

    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth((Component)((Object)this));
    }

    public ContatoDateTextField setMaximumWidth(int maximumWidth) {
        return (ContatoDateTextField)((Object)SizeUtils.setMaximumWidth((Component)((Object)this), (int)maximumWidth));
    }

    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight((Component)((Object)this));
    }

    public ContatoDateTextField setMaximumHeight(int maximumHeight) {
        return (ContatoDateTextField)((Object)SizeUtils.setMaximumHeight((Component)((Object)this), (int)maximumHeight));
    }

    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize((Component)((Object)this), (Dimension)super.getPreferredSize());
    }

    public ContatoDateTextField setPreferredSize(int width, int height) {
        return (ContatoDateTextField)((Object)SizeUtils.setPreferredSize((Component)((Object)this), (int)width, (int)height));
    }

    @Override
    public void setReadOnly() {
        super.putClientProperty((Object)"ACCESS", (Object)0);
    }

    @Override
    public void setReadWrite() {
        super.putClientProperty((Object)"ACCESS", (Object)1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        super.putClientProperty((Object)"ACCESS", (Object)2);
    }

    @Override
    public void setDontController() {
        super.putClientProperty((Object)"ACCESS", (Object)-10);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            if (this.selectAllOnFocusGained) {
                this.selectAll();
            }
            this.changeCollorFocusGained();
        } else if (e.getID() == 1005) {
            this.setSelectionEnd(0);
            this.changeCollorFocusLost();
        }
    }

    @Override
    public void changeCollorFocusGained() {
        this.setBackground(COLOR_FOCUS_GAINED);
    }

    @Override
    public void changeCollorFocusLost() {
        this.setBackground(this.def);
    }

    public boolean isSelectAllOnFocusGained() {
        return this.selectAllOnFocusGained;
    }

    public void setSelectAllOnFocusGained(boolean selectAllOnFocusGained) {
        this.selectAllOnFocusGained = selectAllOnFocusGained;
    }

    public void setPreferredSize(Dimension preferredSize) {
        Dimension d = this.checkMinimunDimension(preferredSize);
        super.setPreferredSize(d);
    }

    public void setMinimumSize(Dimension minimumSize) {
        Dimension d = this.checkMinimunDimension(minimumSize);
        super.setMinimumSize(d);
    }

    private Dimension checkMinimunDimension(Dimension d) {
        int height = d.height;
        int width = d.width;
        if (height < MIN_HEIGHT) {
            height = MIN_HEIGHT;
        }
        if (width < MIN_WIDHT) {
            width = MIN_WIDHT;
        }
        return new Dimension(width, height);
    }

    public void commitEdit() throws ParseException {
        super.commitEdit();
        String newValue = super.getText().trim();
        if (newValue == null) {
            newValue = "";
        }
        char[] dataValor = newValue.toCharArray();
        char[] dataCorrente = this.dateFormat.format(new Date()).toCharArray();
        char[] arrayDate = new char[dataCorrente.length];
        for (int i = 0; i < arrayDate.length; ++i) {
            char ch1 = dataValor[i];
            char ch2 = dataCorrente[i];
            arrayDate[i] = ch1 == ' ' ? ch2 : ch1;
        }
        this.setText(new String(arrayDate));
    }

    protected Date processStrDate() {
        try {
            try {
                super.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            String newValue = super.getText();
            if (newValue == null) {
                newValue = "";
            }
            if (ContatoStringUtil.refina(newValue).length() == 0) {
                return null;
            }
            char[] dataValor = newValue.toCharArray();
            char[] dataCorrente = this.dateFormat.format(new Date()).toCharArray();
            char[] arrayDate = new char[dataCorrente.length];
            for (int i = 0; i < arrayDate.length; ++i) {
                int ch1 = 32;
                if (i < dataValor.length) {
                    ch1 = dataValor[i];
                }
                int ch2 = dataCorrente[i];
                arrayDate[i] = ch1 == 32 ? ch2 : ch1;
            }
            this.date = this.dateFormat.parse(new String(arrayDate));
            return this.date;
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoDateTimeTextField.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.setDate(null);
    }

    public void buildFormatter(SimpleDateFormat simpleDateFormat, DefaultFormatterFactory maskDateTime) {
        this.dateFormat = simpleDateFormat;
        this.setFormatterFactory(maskDateTime);
    }

    protected static enum UpdateSource {
        field,
        calendar,
        other;

    }
}

