/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.alee.extended.date.DateSelectionListener;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateField;
import com.alee.extended.date.WebDateFieldStyle;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.text.WebFormattedTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.settings.SettingsMethods;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.Customizer;
import com.alee.utils.swing.SizeMethods;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ColorFocus;
import contatocore.util.ContatoMaskFactory;
import contatocore.util.ContatoStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.DefaultFormatterFactory;

public class ContatoDateTimeTextField
extends WebFormattedTextField
implements ShapeProvider,
SettingsMethods,
SizeMethods<WebFormattedTextField>,
ContatoControllerComponent,
ContatoClearComponent,
ColorFocus {
    private boolean selectAllOnFocusGained = true;
    Color def = null;
    public static final ImageIcon selectDateIcon = new ImageIcon(WebDateField.class.getResource("icons/date.png"));
    protected List<DateSelectionListener> dateSelectionListeners = new ArrayList<DateSelectionListener>(1);
    protected boolean fireSelectionWithoutChanges = true;
    protected SimpleDateFormat dateFormat;
    protected Date date = null;
    protected Customizer<WebCalendar> calendarCustomizer = null;
    protected WebButton popupButton;
    protected WebWindow popup;
    protected WebCalendar calendar;
    protected DateSelectionListener dateSelectionListener;
    private Integer MIN_HEIGHT = 30;
    private Integer MIN_WIDHT = 140;

    public ContatoDateTimeTextField() {
        this.setReadWrite();
        this.setHorizontalAlignment(0);
        this.setSize(new Dimension(this.MIN_WIDHT, this.MIN_HEIGHT));
        this.setPreferredSize(new Dimension(this.MIN_WIDHT, this.MIN_HEIGHT));
        this.setMinimumSize(new Dimension(this.MIN_WIDHT, this.MIN_HEIGHT));
        this.buildFormatter(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss"), ContatoMaskFactory.getMaskDateTime("##/##/#### ##:##:##"));
        this.popupButton = WebButton.createIconWebButton((ImageIcon)selectDateIcon, (int)WebDateFieldStyle.round);
        this.popupButton.setFocusable(false);
        this.popupButton.setShadeWidth(0);
        this.popupButton.setMoveIconOnPress(false);
        this.popupButton.setRolloverDecoratedOnly(true);
        this.popupButton.setCursor(Cursor.getDefaultCursor());
        this.popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContatoDateTimeTextField.this.showCalendarPopup();
            }
        });
        this.setTrailingComponent((JComponent)this.popupButton);
        this.setOpaque(false);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawBackground(WebDateFieldStyle.drawBackground);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawFocus(WebDateFieldStyle.drawFocus);
        this.popupButton = WebButton.createIconWebButton((ImageIcon)selectDateIcon, (int)WebDateFieldStyle.round);
        this.popupButton.setFocusable(false);
        this.popupButton.setShadeWidth(0);
        this.popupButton.setMoveIconOnPress(false);
        this.popupButton.setRolloverDecoratedOnly(true);
        this.popupButton.setCursor(Cursor.getDefaultCursor());
        this.popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContatoDateTimeTextField.this.showCalendarPopup();
            }
        });
        this.setTrailingComponent((JComponent)this.popupButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContatoDateTimeTextField.this.setDateFromField(true);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ContatoDateTimeTextField.this.isEnabled() && SwingUtilities.isRightMouseButton(e)) {
                    ContatoDateTimeTextField.this.showCalendarPopup();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!SwingUtils.isEqualOrChild((Component)ContatoDateTimeTextField.this.popup, (Component)e.getOppositeComponent())) {
                    ContatoDateTimeTextField.this.setDateFromField(true);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (ContatoDateTimeTextField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(e)) {
                        ContatoDateTimeTextField.this.updateFieldFromDate();
                    } else if (Hotkey.DOWN.isTriggered(e)) {
                        ContatoDateTimeTextField.this.showCalendarPopup();
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ContatoDateTimeTextField.this.hideCalendarPopup();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ContatoDateTimeTextField.this.hideCalendarPopup();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ContatoDateTimeTextField.this.hideCalendarPopup();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ContatoDateTimeTextField.this.hideCalendarPopup();
            }
        });
        this.updateFieldFromDate();
        this.setRound(WebDateFieldStyle.round);
        this.setShadeWidth(WebDateFieldStyle.shadeWidth);
    }

    public ContatoDateTimeTextField(boolean drawBorder) {
        this(null, drawBorder);
    }

    public ContatoDateTimeTextField(Date date) {
        this(date, WebDateFieldStyle.drawBorder);
    }

    public ContatoDateTimeTextField(Date date, boolean drawBorder) {
        this();
        this.date = date;
        this.setDrawBorder(drawBorder);
    }

    public WebButton getPopupButton() {
        return this.popupButton;
    }

    public void setRound(int round) {
        super.setRound(round);
        this.popupButton.setRound(round);
    }

    public void setDrawBorder(boolean drawBorder) {
        super.setDrawBorder(drawBorder);
        this.updateMargin();
    }

    public Customizer<WebCalendar> getCalendarCustomizer() {
        return this.calendarCustomizer;
    }

    public void setCalendarCustomizer(Customizer<WebCalendar> customizer) {
        this.calendarCustomizer = customizer;
        if (customizer != null && this.calendar != null) {
            customizer.customize((Object)this.calendar);
        }
    }

    protected void updateMargin() {
        this.setMargin(this.isDrawBorder() ? WebDateFieldStyle.margin : WebDateFieldStyle.undecoratedMargin);
    }

    protected void showCalendarPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.setDateFromField(false);
        if (this.popup == null || this.calendar == null) {
            Window ancestor = SwingUtils.getWindowAncestor((Component)((Object)this));
            this.calendar = new WebCalendar(this.date);
            this.calendar.setPaintFocus(false);
            this.calendar.setRound(StyleConstants.smallRound);
            this.calendar.setShadeWidth(0);
            if (this.calendarCustomizer != null) {
                this.calendarCustomizer.customize((Object)this.calendar);
            }
            this.popup = new WebWindow(ancestor);
            this.popup.setLayout((LayoutManager)new BorderLayout());
            this.popup.setCloseOnFocusLoss(true);
            this.popup.setWindowOpaque(false);
            this.popup.add((Component)this.calendar);
            this.customizePopup(this.popup);
            this.popup.pack();
            this.updatePopupLocation();
            ancestor.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ContatoDateTimeTextField.this.popup.isShowing()) {
                        ContatoDateTimeTextField.this.updatePopupLocation();
                    }
                }
            });
            this.dateSelectionListener = new DateSelectionListener(){

                public void dateSelected(Date date) {
                    ContatoDateTimeTextField.this.hideCalendarPopup();
                    ContatoDateTimeTextField.this.setDateFromCalendar(true);
                    ContatoDateTimeTextField.this.requestFocusInWindow();
                }
            };
            this.calendar.addDateSelectionListener(this.dateSelectionListener);
        } else {
            this.updatePopupLocation();
        }
        SwingUtils.copyOrientation((Component)((Object)this), (Component)this.popup);
        this.popup.setVisible(true);
        this.calendar.transferFocus();
    }

    protected void customizePopup(WebWindow popup) {
    }

    protected void hideCalendarPopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    protected void updatePopupLocation() {
        Point los = this.getLocationOnScreen();
        Rectangle gb = this.popup.getGraphicsConfiguration().getBounds();
        int shadeWidth = this.isDrawBorder() ? this.getShadeWidth() : 0;
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = ltr ? (los.x + shadeWidth + this.popup.getWidth() <= gb.x + gb.width ? los.x + shadeWidth : los.x + w - shadeWidth - this.popup.getWidth()) : (los.x + w - shadeWidth - this.popup.getWidth() >= gb.x ? los.x + w - shadeWidth - this.popup.getWidth() : los.x + shadeWidth);
        int y = los.y + h + this.popup.getHeight() <= gb.y + gb.height ? los.y + h + (this.isDrawBorder() ? 0 : 1) : los.y - this.popup.getHeight() - (this.isDrawBorder() ? 0 : 1);
        this.popup.setLocation(x, y);
    }

    protected Date getDateFromField() {
        try {
            return this.processStrDate();
        }
        catch (Throwable ex) {
            return this.date;
        }
    }

    protected String getTextDate() {
        return this.date != null ? this.dateFormat.format(this.date) : "";
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.setDateImpl(date, UpdateSource.other, true);
    }

    public void updateDateFromField(boolean fireEvent) {
        this.setDateFromField(fireEvent);
    }

    protected void setDateFromField(boolean fireEvent) {
        this.setDateImpl(this.getDateFromField(), UpdateSource.field, fireEvent);
    }

    protected void setDateFromCalendar(boolean fireEvent) {
        this.setDateImpl(this.calendar.getDate(), UpdateSource.calendar, fireEvent);
    }

    protected void setDateImpl(Date date, UpdateSource source, boolean fireEvent) {
        this.date = date;
        if (date == null) {
            super.setValue((Object)date);
        }
        this.updateFieldFromDate();
        if (this.fireSelectionWithoutChanges) {
            if (source != UpdateSource.calendar && this.calendar != null) {
                this.updateCalendarFromDate(date);
            }
            if (fireEvent) {
                this.fireDateSelected(date);
            }
        }
    }

    protected void updateFieldFromDate() {
        this.setText(this.getTextDate());
        this.setCaretPosition(0);
    }

    protected void updateCalendarFromDate(Date date) {
        this.calendar.removeDateSelectionListener(this.dateSelectionListener);
        this.calendar.setDate(date);
        this.calendar.addDateSelectionListener(this.dateSelectionListener);
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.updateFieldFromDate();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.popupButton.setEnabled(enabled);
    }

    public boolean isFireSelectionWithoutChanges() {
        return this.fireSelectionWithoutChanges;
    }

    public void setFireSelectionWithoutChanges(boolean fire) {
        this.fireSelectionWithoutChanges = fire;
    }

    public void addDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.add(listener);
    }

    public void removeDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.remove(listener);
    }

    public void fireDateSelected(Date date) {
        for (DateSelectionListener listener : CollectionUtils.copy(this.dateSelectionListeners)) {
            listener.dateSelected(date);
        }
    }

    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth((Component)((Object)this));
    }

    public ContatoDateTimeTextField setPreferredWidth(int preferredWidth) {
        return (ContatoDateTimeTextField)((Object)SizeUtils.setPreferredWidth((Component)((Object)this), (int)preferredWidth));
    }

    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight((Component)((Object)this));
    }

    public ContatoDateTimeTextField setPreferredHeight(int preferredHeight) {
        return (ContatoDateTimeTextField)((Object)SizeUtils.setPreferredHeight((Component)((Object)this), (int)preferredHeight));
    }

    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth((Component)((Object)this));
    }

    public ContatoDateTimeTextField setMinimumWidth(int minimumWidth) {
        return (ContatoDateTimeTextField)((Object)SizeUtils.setMinimumWidth((Component)((Object)this), (int)minimumWidth));
    }

    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight((Component)((Object)this));
    }

    public ContatoDateTimeTextField setMinimumHeight(int minimumHeight) {
        return (ContatoDateTimeTextField)((Object)SizeUtils.setMinimumHeight((Component)((Object)this), (int)minimumHeight));
    }

    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth((Component)((Object)this));
    }

    public ContatoDateTimeTextField setMaximumWidth(int maximumWidth) {
        return (ContatoDateTimeTextField)((Object)SizeUtils.setMaximumWidth((Component)((Object)this), (int)maximumWidth));
    }

    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight((Component)((Object)this));
    }

    public ContatoDateTimeTextField setMaximumHeight(int maximumHeight) {
        return (ContatoDateTimeTextField)((Object)SizeUtils.setMaximumHeight((Component)((Object)this), (int)maximumHeight));
    }

    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize((Component)((Object)this), (Dimension)super.getPreferredSize());
    }

    public ContatoDateTimeTextField setPreferredSize(int width, int height) {
        return (ContatoDateTimeTextField)((Object)SizeUtils.setPreferredSize((Component)((Object)this), (int)width, (int)height));
    }

    public void buildFormatter(SimpleDateFormat simpleDateFormat, DefaultFormatterFactory maskDateTime) {
        this.dateFormat = simpleDateFormat;
        this.setFormatterFactory(maskDateTime);
    }

    @Override
    public void setReadOnly() {
        super.putClientProperty((Object)"ACCESS", (Object)0);
    }

    @Override
    public void setReadWrite() {
        super.putClientProperty((Object)"ACCESS", (Object)1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        super.putClientProperty((Object)"ACCESS", (Object)2);
    }

    @Override
    public void setDontController() {
        super.putClientProperty((Object)"ACCESS", (Object)-10);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            if (this.selectAllOnFocusGained) {
                this.selectAll();
            }
            this.changeCollorFocusGained();
        } else if (e.getID() == 1005) {
            this.setSelectionEnd(0);
            this.changeCollorFocusLost();
        }
    }

    @Override
    public void changeCollorFocusGained() {
    }

    @Override
    public void changeCollorFocusLost() {
    }

    public boolean isSelectAllOnFocusGained() {
        return this.selectAllOnFocusGained;
    }

    public void setSelectAllOnFocusGained(boolean selectAllOnFocusGained) {
        this.selectAllOnFocusGained = selectAllOnFocusGained;
    }

    public void setPreferredSize(Dimension preferredSize) {
        Dimension d = this.checkMinimunDimension(preferredSize);
        super.setPreferredSize(d);
    }

    public void setMinimumSize(Dimension minimumSize) {
        Dimension d = this.checkMinimunDimension(minimumSize);
        super.setMinimumSize(d);
    }

    private Dimension checkMinimunDimension(Dimension d) {
        int height = d.height;
        int width = d.width;
        if (height < this.MIN_HEIGHT) {
            height = this.MIN_HEIGHT;
        }
        if (width < this.MIN_WIDHT) {
            width = this.MIN_WIDHT;
        }
        return new Dimension(width, height);
    }

    protected Date processStrDate() {
        try {
            try {
                super.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            String newValue = super.getText();
            if (newValue == null) {
                newValue = "";
            }
            if (ContatoStringUtil.refina(newValue).length() == 0) {
                return null;
            }
            char[] dataValor = newValue.toCharArray();
            char[] dataCorrente = this.dateFormat.format(new Date()).toCharArray();
            char[] arrayDate = new char[dataCorrente.length];
            for (int i = 0; i < arrayDate.length; ++i) {
                int ch1 = 32;
                if (i < dataValor.length) {
                    ch1 = dataValor[i];
                }
                int ch2 = dataCorrente[i];
                arrayDate[i] = ch1 == 32 ? ch2 : ch1;
            }
            return this.dateFormat.parse(new String(arrayDate));
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoDateTimeTextField.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.setDate(null);
    }

    protected static enum UpdateSource {
        field,
        calendar,
        other;

    }
}

