/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoCepTextField;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoMaskFactory;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nfunk.jep.JEP;

public class ContatoDoubleTextField
extends ContatoFormattedTextField {
    private boolean verifyValor = true;
    private Double maxValue = null;
    private Double minValue = null;

    public ContatoDoubleTextField() {
        this.initTextField();
    }

    public ContatoDoubleTextField(int decimalSize) {
        this();
        this.initTextField();
        this.setFormatterFactory(ContatoMaskFactory.getDefaultDoubleFormatterDecimalSize(decimalSize));
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public void setMinMaxValue(Double minValue, Double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void commitEdit() throws ParseException {
        this.processarFormula();
        if (this.processarMinMaxValue(this.getText()).booleanValue()) {
            super.commitEdit();
        } else {
            this.setDouble(this.minValue == null ? (this.maxValue == null ? 0.0 : this.maxValue) : this.minValue);
            this.selectAll();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            this.selectAll();
        } else if (e.getID() == 1005) {
            try {
                this.commitEdit();
                if (this.isVerifyValor() && this.getDouble() < 0.0) {
                    ContatoDialogsHelper.showError("Valor inv\u00e1lido!");
                    this.setDouble(0.0);
                }
            }
            catch (ParseException ex) {
                this.setValue(0.0);
            }
        }
    }

    public Double getDouble() {
        try {
            if (this.getValue() == null) {
                this.setValue(0.0);
            }
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCepTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (Double)this.getValue();
    }

    public void setDouble(Double value) {
        this.setValue(value);
    }

    @Override
    public void clear() {
        this.setValue(0.0);
    }

    @Override
    public void setValue(Object value) {
        Double newValue = null;
        if (value != null) {
            try {
                if (!(value instanceof Double)) {
                    throw new ContatoInvalidValueException("Invalid value: " + value.getClass() + " expected: java.util.Double");
                }
                newValue = (Double)value;
            }
            catch (ContatoInvalidValueException ex) {
                ex.printStackTrace();
            }
        }
        super.setValue(newValue);
    }

    public boolean isVerifyValor() {
        return this.verifyValor;
    }

    public void setVerifyValor(boolean verifyValor) {
        this.verifyValor = verifyValor;
    }

    private void processarFormula() {
        if (this.getText() != null && this.getText().startsWith("=")) {
            try {
                JEP myParser = new JEP();
                myParser.parseExpression(this.getText().substring(1));
                Double valor = myParser.getValue();
                this.setText(ContatoMaskFactory.getDefaultDoubleFormatter().getDefaultFormatter().valueToString(valor));
            }
            catch (ParseException ex) {
                Logger.getLogger(ContatoDoubleTextField.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Boolean processarMinMaxValue(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                Double doubleValue = Double.parseDouble(value.replace(".", "").replace(",", "."));
                if (this.minValue != null && this.maxValue != null) {
                    return doubleValue >= this.minValue && doubleValue <= this.maxValue;
                }
                if (this.minValue != null) {
                    return doubleValue >= this.minValue;
                }
                if (this.maxValue != null) {
                    return doubleValue <= this.maxValue;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    private void initTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getDefaultDoubleFormatter());
        this.setValue(0.0);
        this.setHorizontalAlignment(4);
        this.setToolTipText("Campo numerico: ");
    }
}

