/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.controller.ContatoFixedLengthDocument;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoComponent30x30Size;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ColorFocus;
import contato.util.ContatoTextUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ContatoFormattedTextField
extends JFormattedTextField
implements ContatoControllerComponent,
ContatoClearComponent,
ColorFocus,
ContatoComponent30x30Size {
    Color def = null;

    public ContatoFormattedTextField() {
        this.initRedoAndUndo();
        this.setPreferredSize(new Dimension(70, 20));
        this.setMinimumSize(new Dimension(70, 20));
        this.setReadWrite();
        this.setFocusLostBehavior(1);
        ContatoTextUtilities.initBasicPopupTextMenu(this);
        this.def = this.getBackground();
    }

    public void setFixedSize(int size) {
        this.setDocument(new ContatoFixedLengthDocument(size));
    }

    private void initRedoAndUndo() {
        final UndoManager undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            this.selectAll();
            this.changeCollorFocusGained();
        } else if (e.getID() == 1005) {
            this.selectAll();
            this.changeCollorFocusLost();
        }
    }

    @Override
    public void commitEdit() throws ParseException {
        try {
            super.commitEdit();
        }
        catch (ParseException ex) {
            this.setValue(null);
            throw ex;
        }
    }

    public String getString() {
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.getText();
    }

    public void setString(String str) {
        this.setValue(str);
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void clear() {
        this.setValue(null);
        this.setText(null);
    }

    @Override
    public String getToolTipText() {
        String text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = text + "<html><b>" + super.getToolTipText();
            text = text + "</b>" + (this.getText() != null && this.getText().trim().length() > 0 ? "<br>" + this.getText() : "");
            text = text + "</html>";
        }
        return text;
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    @Override
    public void changeCollorFocusGained() {
    }

    @Override
    public void changeCollorFocusLost() {
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        Dimension d = this.checkMinimunDimension(preferredSize);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        Dimension d = this.checkMinimunDimension(minimumSize);
        super.setMinimumSize(d);
    }

    private Dimension checkMinimunDimension(Dimension d) {
        int height = d.height;
        int width = d.width;
        if (height < MIN_HEIGHT) {
            height = MIN_HEIGHT;
        }
        if (width < MIN_WIDHT) {
            width = MIN_WIDHT;
        }
        return new Dimension(width, height);
    }
}

