/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoMaskFactory;
import java.awt.event.FocusEvent;
import java.text.ParseException;

public class ContatoIntegerTextField
extends ContatoFormattedTextField {
    private boolean verifyValor = true;

    public ContatoIntegerTextField(int integerDigits) {
        this.setHorizontalAlignment(4);
        this.setFormatterFactory(ContatoMaskFactory.getIntegerFormatterDigits(integerDigits));
        this.setValue(new Integer(0));
        this.setToolTipText("Campo inteiro: ");
    }

    public ContatoIntegerTextField() {
        this.setHorizontalAlignment(4);
        this.setFormatterFactory(ContatoMaskFactory.getDefaultIntegerFormatter());
        this.setToolTipText("Campo inteiro: ");
    }

    public Integer getInteger() {
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (Integer)this.getValue();
    }

    public void setInteger(Integer number) {
        this.setValue(number);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (this.isVerifyValor() && this.getInteger() != null && this.getInteger() < 0) {
            ContatoDialogsHelper.showError("Valor inv\u00e1lido!");
            this.setInteger(0);
        }
    }

    @Override
    public void clear() {
        this.setValue(0);
    }

    @Override
    public void setValue(Object value) {
        Integer newValue = null;
        if (value != null) {
            try {
                if (!(value instanceof Integer)) {
                    throw new ContatoInvalidValueException("Invalid value: " + value.getClass() + " expected: java.util.Integer");
                }
                newValue = (Integer)value;
            }
            catch (ContatoInvalidValueException ex) {
                ex.printStackTrace();
            }
        }
        super.setValue(newValue);
    }

    public boolean isVerifyValor() {
        return this.verifyValor;
    }

    public void setVerifyValor(boolean verifyValor) {
        this.verifyValor = verifyValor;
    }
}

