/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.interfaces.ContatoClearComponent;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoFormatUtil;
import contatocore.util.ContatoStringUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class ContatoMaskTextField
extends ContatoFormattedTextField
implements ContatoClearComponent {
    private boolean completaZerosEsquerda;
    private boolean completaZerosDireita;
    private int qtdCaracteres;

    public ContatoMaskTextField() {
        this((String)null);
    }

    public ContatoMaskTextField(String mask) {
        if (mask != null) {
            this.setMask(mask);
        } else {
            this.setFormatter(new DefaultFormatter());
            this.setFormatterFactory(new DefaultFormatterFactory());
        }
        this.setValue(null);
        this.setToolTipText("Campo formatado: ");
        this.setHorizontalAlignment(0);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (ContatoMaskTextField.this.getText() == null || ContatoMaskTextField.this.getText().trim().length() == 0) {
                    ContatoMaskTextField.this.setValue(null);
                } else if (ContatoMaskTextField.this.completaZerosEsquerda) {
                    ContatoMaskTextField.this.setText(ContatoFormatUtil.completaZerosEsquerda(ContatoStringUtil.refina(ContatoMaskTextField.this.getText().trim()), ContatoMaskTextField.this.qtdCaracteres));
                    ContatoMaskTextField.this.setValue(ContatoFormatUtil.completaZerosEsquerda(ContatoStringUtil.refina(ContatoMaskTextField.this.getText().trim()), ContatoMaskTextField.this.qtdCaracteres));
                } else if (ContatoMaskTextField.this.completaZerosDireita) {
                    ContatoMaskTextField.this.setText(ContatoFormatUtil.completaZerosDireita(ContatoStringUtil.refina(ContatoMaskTextField.this.getText().trim()), ContatoMaskTextField.this.qtdCaracteres));
                    ContatoMaskTextField.this.setValue(ContatoFormatUtil.completaZerosDireita(ContatoStringUtil.refina(ContatoMaskTextField.this.getText().trim()), ContatoMaskTextField.this.qtdCaracteres));
                }
            }

            public String toString() {
                return "naoRemover";
            }
        });
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        if (l.toString() == null || !l.toString().equals("naoRemover")) {
            super.removeFocusListener(l);
        }
    }

    public void naoCompletarZeros() {
        this.completaZerosDireita = false;
        this.completaZerosEsquerda = false;
    }

    public void setCompletaZerosEsquerda(boolean value) {
        this.completaZerosDireita = !value;
        this.completaZerosEsquerda = value;
    }

    public void setCompletaZerosDireita(boolean value) {
        this.completaZerosDireita = value;
        this.completaZerosEsquerda = !value;
    }

    public int getQtdCaracteres() {
        return this.qtdCaracteres;
    }

    public void setQtdCaracteres(int qtdCaracteres) {
        this.qtdCaracteres = qtdCaracteres;
    }

    private void setMask(String mascara) {
        try {
            MaskFormatter mask = new MaskFormatter(mascara);
            DefaultFormatterFactory factory = new DefaultFormatterFactory(mask, mask, mask);
            this.setFormatterFactory(factory);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

