/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.interfaces.ContatoClearComponent;
import contato.swing.ContatoDateTextField;
import contato.swing.ContatoLabel;
import contatocore.util.ContatoDateUtil;
import contatocore.util.UtilAbstractObjectBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JPanel;

public class ContatoRangeDateField
extends JPanel
implements FocusListener,
ContatoClearComponent {
    public static final String DD_MM_YYYY_CLASSIC = "dd/MM/yyyy";
    public static final Locale PT_BR_LOCALE = new Locale("pt", "BR", "ISO8859-1");
    private ContatoLabel contatoLabel1;
    private ContatoLabel contatoLabel2;
    private ContatoDateTextField txtDateFinal;
    private ContatoDateTextField txtDateInicial;

    public ContatoRangeDateField() {
        this.initComponents();
        this.initEvent();
    }

    private void initComponents() {
        this.contatoLabel1 = new ContatoLabel();
        this.txtDateFinal = new ContatoDateTextField();
        this.contatoLabel2 = new ContatoLabel();
        this.txtDateInicial = new ContatoDateTextField();
        this.setLayout(new GridBagLayout());
        this.contatoLabel1.setText("Data Inicial");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        this.add((Component)this.contatoLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)((Object)this.txtDateFinal), gridBagConstraints);
        this.contatoLabel2.setText("Data Final");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)this.contatoLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        this.add((Component)((Object)this.txtDateInicial), gridBagConstraints);
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if (fe.getSource().equals(this.txtDateInicial)) {
            if (this.txtDateInicial.getDate() == null) {
                this.setValidDateInicial();
            }
            this.validarData();
            this.txtDateFinal.requestFocus();
        } else if (fe.getSource().equals(this.txtDateFinal)) {
            if (this.txtDateFinal.getDate() == null) {
                this.setValidDateFinal();
            }
            this.validarData();
        }
    }

    private void validarData() {
        if (this.retornoDataSemHora(this.txtDateFinal.getDate()) != null && this.retornoDataSemHora(this.txtDateInicial.getDate()) != null && this.retornoDataSemHora(this.txtDateFinal.getDate()).before(this.retornoDataSemHora(this.txtDateInicial.getDate()))) {
            DialogsHelper.showError("Data Final n\u00e3o pode ser menor que a Data Inicial");
        }
    }

    private void setValidDateInicial() {
        this.txtDateInicial.setDate(this.novaData());
    }

    private void setValidDateFinal() {
        this.txtDateFinal.setDate(this.novaData());
    }

    private Date retornoDataSemHora(Date data) {
        return ContatoDateUtil.strToDate(ContatoDateUtil.dateToStr(data), DD_MM_YYYY_CLASSIC);
    }

    private Date novaData() {
        return ContatoDateUtil.strToDate(ContatoDateUtil.dateToStr(new Date()), DD_MM_YYYY_CLASSIC);
    }

    public Date getDataInicial() {
        return this.txtDateInicial.getDate();
    }

    public void setDataInicial(Date dataInicial) {
        this.txtDateInicial.setDate(dataInicial);
    }

    public Date getDataFinal() {
        return this.txtDateFinal.getDate();
    }

    public void setDataFinal(Date dataFinal) {
        this.txtDateFinal.setDate(dataFinal);
    }

    private void initEvent() {
        this.txtDateFinal.addFocusListener(this);
        this.txtDateInicial.addFocusListener(this);
    }

    public boolean isValidBefore() {
        if (this.txtDateInicial.getDate() == null) {
            DialogsHelper.showError("Data inicial \u00e9 obrigat\u00f3rio.");
            this.txtDateInicial.requestFocus();
            return false;
        }
        if (this.txtDateFinal.getDate() == null) {
            DialogsHelper.showError("Data final \u00e9 obrigat\u00f3rio.");
            this.txtDateFinal.requestFocus();
            return false;
        }
        if (this.txtDateFinal.getDate().before(this.txtDateInicial.getDate())) {
            DialogsHelper.showError("Data final deve ser maior oou igual a data inicial.");
            this.txtDateFinal.requestFocus();
            return false;
        }
        return true;
    }

    public static Date strToDate(String strDate) {
        return ContatoRangeDateField.strToDate(strDate, DD_MM_YYYY_CLASSIC);
    }

    public static Date strToDate(String strDate, String pattern) {
        try {
            if (strDate != null && pattern != null) {
                Date tempDate = null;
                SimpleDateFormat sd = new SimpleDateFormat(pattern, PT_BR_LOCALE);
                if (ContatoRangeDateField.refina(strDate) == "") {
                    return null;
                }
                tempDate = sd.parse(strDate);
                return tempDate;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("Erro ao converter a Data");
        }
    }

    public static String refina(String cadastro) {
        String cadastroRefinado = "";
        if (cadastro == null) {
            return "";
        }
        for (int i = 0; i < cadastro.length(); ++i) {
            char carac = cadastro.charAt(i);
            if (carac == '/' || carac == '.' || carac == '-' || carac == ' ' || carac == ',' || carac == ':') continue;
            cadastroRefinado = cadastroRefinado + String.valueOf(carac);
        }
        return cadastroRefinado;
    }

    @Override
    public void clear() {
        this.txtDateFinal.clear();
        this.txtDateInicial.clear();
    }

    private static class DialogsHelper {
        private DialogsHelper() {
        }

        public static void showError(String errorMessage) {
            try {
                Class<?> c = Class.forName("mentor.gui.dialogs.DialogsHelper");
                Method showError = UtilAbstractObjectBuilder.searchMethod("showError", c, 1);
                showError.invoke(null, errorMessage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void showInfo(String msg) {
            try {
                Class<?> c = Class.forName("mentor.gui.dialogs.DialogsHelper");
                Method showInfo = UtilAbstractObjectBuilder.searchMethod("showInfo", c, 1);
                showInfo.invoke(null, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

