/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class ContatoRotatingLabel
extends JLabel {
    private int rotation = 0;
    private int width;
    private int height;
    private Image img;
    private Boolean rotateAction = false;

    public ContatoRotatingLabel() {
        this.setText("");
        new Timer(2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ContatoRotatingLabel.this.rotateAction.booleanValue()) {
                    ContatoRotatingLabel.this.rotate();
                }
            }
        }).start();
    }

    public ContatoRotatingLabel(Icon image) {
        super(image);
    }

    public ContatoRotatingLabel(String text) {
        super(text);
    }

    public ContatoRotatingLabel(Icon image, int horizontalAligment) {
        super(image, horizontalAligment);
    }

    public ContatoRotatingLabel(String text, int horizontalAligment) {
        super(text, horizontalAligment);
    }

    public ContatoRotatingLabel(String text, Icon icon, int horizontalAligment) {
        super(text, icon, horizontalAligment);
    }

    private void rotate() {
        if (this.isVisible()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ContatoRotatingLabel.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.rotation += 10;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.img = ((ImageIcon)this.getIcon()).getImage();
        if (this.img == null) {
            super.paintComponent(g);
        } else {
            this.width = this.getIcon().getIconWidth();
            this.height = this.getIcon().getIconHeight();
            Graphics2D g2 = (Graphics2D)g;
            Dimension sz = this.getSize();
            int sw2 = sz.width / 2;
            int sh2 = sz.height / 2;
            g2.translate(sw2, sh2);
            g2.rotate(Math.PI * (double)this.rotation / 360.0);
            g2.translate(-sw2, -sh2);
            g2.drawImage(this.img, sw2 - this.width / 2, sh2 - this.height / 2, this);
        }
    }

    public void startRotate() {
        this.rotateAction = true;
    }

    public void stopRotate() {
        this.rotateAction = false;
    }
}

