/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoFormattedTextField;
import contato.swing.datechooser.ContatoDateChooserFrame;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoMaskFactory;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Popup;

public class ContatoTableDateTextField
extends ContatoFormattedTextField {
    Popup popup;

    public ContatoTableDateTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getMaskDate());
        this.setHorizontalAlignment(0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 18) {
                    this.pesquisarData();
                }
                super.keyPressed(e);
            }

            private void pesquisarData() {
                ContatoTableDateTextField.this.setDate(ContatoDateChooserFrame.getDateForChoice(ContatoTableDateTextField.this.getDate(), ContatoTableDateTextField.this.getLocationOnScreen()));
            }
        });
        this.buildCalendarIcon();
    }

    public ContatoTableDateTextField(Boolean showCalendarIcon) {
        this.setFormatterFactory(ContatoMaskFactory.getMaskDate());
        this.setHorizontalAlignment(0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 18) {
                    this.pesquisarData();
                }
                super.keyPressed(e);
            }

            private void pesquisarData() {
                ContatoTableDateTextField.this.setDate(ContatoDateChooserFrame.getDateForChoice(ContatoTableDateTextField.this.getDate(), ContatoTableDateTextField.this.getLocationOnScreen()));
            }
        });
        if (showCalendarIcon.booleanValue()) {
            this.buildCalendarIcon();
        }
    }

    private void buildCalendarIcon() {
    }

    public ContatoTableDateTextField getInstance() {
        return this;
    }

    @Override
    public void setValue(Object value) {
        String newValue = null;
        try {
            if (value != null) {
                if (!(value instanceof Date)) {
                    throw new ContatoInvalidValueException("Invalid value: " + value.getClass() + " expected: java.util.Date");
                }
                newValue = ContatoDateUtil.dateToStr((Date)value, "dd/MM/yyyy");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.setValue(newValue);
    }

    @Override
    public void commitEdit() throws ParseException {
        block11: {
            String newValue = super.getText().trim();
            try {
                if (newValue != null && newValue.length() > 7) {
                    if (newValue.length() == 10) {
                        try {
                            ContatoDateUtil.strToDate(newValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new ParseException("Data inv\u00e1lida!", 5);
                        }
                    }
                    if (newValue.length() == 8) {
                        try {
                            newValue = ContatoDateUtil.dateToStr(ContatoDateUtil.strToDate(newValue, "dd/MM/yy"));
                            super.setText(newValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new ParseException("Data inv\u00e1lida!", 5);
                        }
                    }
                    try {
                        super.commitEdit();
                        break block11;
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        throw new ParseException("Data Inv\u00e1lida!", 5);
                    }
                }
                super.setValue(null);
            }
            catch (ParseException ex) {
                super.setValue(null);
                this.requestFocus();
            }
        }
    }

    public Date getDate() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null) {
            try {
                value = ContatoDateUtil.strToDate((String)value);
                return (Date)value;
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return null;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
    }

    @Override
    public String getToolTipText() {
        String text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = text + "<html><b>" + super.getToolTipText();
            text = text + "</b>" + (this.getValue() != null && this.getValue().toString().trim().length() > 0 ? "<br>" + this.getValue() : "");
            text = text + "</html>";
        }
        return text;
    }

    public void setDate(Date data) {
        this.setValue(data);
    }
}

