/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoMaskTextField;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoMaskFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoTableTimeTextField
extends ContatoMaskTextField {
    public ContatoTableTimeTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getMaskTimeWithoutSeconds());
        this.setHorizontalAlignment(0);
    }

    @Override
    public void setValue(Object value) {
        Object newValue = null;
        try {
            if (value != null) {
                newValue = !(value instanceof Date) ? value : ContatoDateUtil.dateToStr((Date)value, "HH:mm");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.setValue(newValue);
    }

    @Override
    public void commitEdit() throws ParseException {
        block7: {
            String newValue = super.getText().trim();
            try {
                if (newValue != null && newValue.length() == 5) {
                    try {
                        ContatoDateUtil.strToDate(newValue, "HH:mm");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ParseException("Data inv\u00e1lida!", 5);
                    }
                    try {
                        super.commitEdit();
                        break block7;
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        throw new ParseException("Data Inv\u00e1lida!", 5);
                    }
                }
                super.setValue(null);
            }
            catch (ParseException ex) {
                super.setValue(null);
                this.requestFocus();
            }
        }
    }

    public Date getDate() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null) {
            try {
                value = ContatoDateUtil.strToDate((String)value, "HH:mm");
                return (Date)value;
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return null;
    }

    @Override
    public String getToolTipText() {
        String text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = text + "<html><b>" + super.getToolTipText();
            text = text + "</b>" + (this.getValue() != null && this.getValue().toString().trim().length() > 0 ? "<br>" + this.getValue() : "");
            text = text + "</html>";
        }
        return text;
    }

    public void setDate(Date data) {
        this.setValue(data);
    }
}

