/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.constants.ContatoConstants;
import contato.controller.ContatoFixedLengthDocument;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoComponent30x30Size;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ColorFocus;
import contato.util.ContatoTextUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ContatoTextField
extends JTextField
implements ContatoControllerComponent,
ContatoClearComponent,
ColorFocus,
ContatoComponent30x30Size {
    Color def = null;
    private boolean selectAllOnFocusGained = true;
    private Boolean alwaysUpper = false;

    public ContatoTextField() {
        this.initTextField();
    }

    public ContatoTextField(String text) {
        super(text);
        this.initTextField();
    }

    public ContatoTextField(int columns) {
        super(columns);
        this.initTextField();
    }

    public ContatoTextField(String text, int columns) {
        super(text, columns);
        this.initTextField();
    }

    public ContatoTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initTextField();
    }

    public void setFixedSize(int size) {
        this.setDocument(new ContatoFixedLengthDocument(size));
    }

    private void initRedoAndUndo() {
        final UndoManager undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            if (this.selectAllOnFocusGained) {
                this.selectAll();
            }
            this.changeCollorFocusGained();
        } else if (e.getID() == 1005) {
            this.setSelectionEnd(0);
            this.changeCollorFocusLost();
        }
    }

    public void setColuns(int numColuns) {
        this.setDocument(new ContatoFixedLengthDocument(numColuns));
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void clear() {
        this.setText(ContatoConstants.EMPTY);
    }

    @Override
    public void setText(String text) {
        super.setText(text != null && this.alwaysUpper != false ? text.toUpperCase() : text);
    }

    private void initTextField() {
        ContatoTextUtilities.initBasicPopupTextMenu(this);
        this.def = this.getBackground();
        this.initRedoAndUndo();
        this.setPreferredSize(new Dimension(250, 20));
        this.setMinimumSize(new Dimension(250, 20));
        this.setReadWrite();
        this.setToolTipText("Campo Texto:");
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
    }

    @Override
    public String getToolTipText() {
        String text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = text + "<html><b>" + super.getToolTipText();
            text = text + "</b>" + (this.getText() != null && this.getText().trim().length() > 0 ? "<br>" + this.getText() : "");
            text = text + "</html>";
        }
        return text;
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    @Override
    public void changeCollorFocusGained() {
    }

    @Override
    public void changeCollorFocusLost() {
    }

    public boolean isSelectAllOnFocusGained() {
        return this.selectAllOnFocusGained;
    }

    public void setSelectAllOnFocusGained(boolean selectAllOnFocusGained) {
        this.selectAllOnFocusGained = selectAllOnFocusGained;
    }

    @Override
    public String getText() {
        String txt;
        Document doc = this.getDocument();
        try {
            txt = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            txt = null;
        }
        txt = txt.replaceAll("\\s+", " ").trim();
        return txt != null && this.alwaysUpper != null && this.alwaysUpper != false ? txt.toUpperCase() : txt;
    }

    public String getTextComEspacos() {
        String txt;
        Document doc = this.getDocument();
        try {
            txt = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            txt = null;
        }
        txt = txt.trim();
        return txt != null && this.alwaysUpper != null && this.alwaysUpper != false ? txt.toUpperCase() : txt;
    }

    public void setAlwaysUpper(Boolean enabled) {
        this.alwaysUpper = enabled != null ? enabled : false;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        Dimension d = this.checkMinimunDimension(preferredSize);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        Dimension d = this.checkMinimunDimension(minimumSize);
        super.setMinimumSize(d);
    }

    private Dimension checkMinimunDimension(Dimension d) {
        int height = d.height;
        int width = d.width;
        if (height < MIN_HEIGHT) {
            height = MIN_HEIGHT;
        }
        if (width < MIN_WIDHT) {
            width = MIN_WIDHT;
        }
        return new Dimension(width, height);
    }

    public String getUpperCaseText() {
        if (this.getText() == null) {
            return null;
        }
        return this.getText().toUpperCase();
    }
}

