/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.TreeTransferHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ContatoTree
extends JTree
implements ContatoControllerComponent,
ContatoClearComponent {
    private TreeTransferHandler treeTransferHandler;

    public ContatoTree(boolean enableDradAndDrop) {
        this.setDragEnabled(enableDradAndDrop);
        if (enableDradAndDrop) {
            this.enableDradAndDrop();
        }
        this.setReadWrite();
        this.setJPopupMenu();
        this.setToolTipText("");
    }

    public void setEnableAndDrop(boolean enableAndDrop) {
        this.setDragEnabled(enableAndDrop);
        if (enableAndDrop) {
            this.enableDradAndDrop();
        }
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
            return null;
        }
        TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (curPath != null && curPath.getLastPathComponent() != null && curPath.getLastPathComponent() instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)curPath.getLastPathComponent()).getUserObject().toString();
        }
        return super.getToolTipText();
    }

    public ContatoTree() {
        this(false);
        this.setToolTipText("");
    }

    public void collapseTree() {
        for (int row = this.getRowCount() - 1; row >= 0; --row) {
            this.collapseRow(row);
        }
    }

    public void selecionarFilhos() {
        for (int row = this.getRowCount() - 1; row >= 0; --row) {
            this.setSelectionRow(row);
        }
    }

    public void expandTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf()) continue;
            int row = this.getRowForPath(new TreePath(node.getPath()));
            this.expandRow(row);
        }
    }

    public void collapseSelectedNodosTree(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf()) continue;
            int row = this.getRowForPath(new TreePath(node.getPath()));
            this.collapseRow(row);
        }
    }

    public void expandSelectedNodosTree(DefaultMutableTreeNode root) {
        if (root == null) {
            return;
        }
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf()) continue;
            int row = this.getRowForPath(new TreePath(node.getPath()));
            this.expandRow(row);
        }
    }

    private void enableDradAndDrop() {
        this.treeTransferHandler = new TreeTransferHandler();
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(this.treeTransferHandler);
        this.getSelectionModel().setSelectionMode(2);
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void clear() {
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    public TreeTransferListener getTreeTransferListener() {
        if (this.treeTransferHandler != null) {
            return this.treeTransferHandler.treeTransferListener;
        }
        return null;
    }

    public void setTreeTransferListener(TreeTransferListener treeTransferListener) {
        if (this.treeTransferHandler == null) {
            throw new RuntimeException("Primeiro habilite drag and drop da jtree");
        }
        this.treeTransferHandler.treeTransferListener = treeTransferListener;
    }

    private void setJPopupMenu() {
        final ContatoTree thisTree = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = thisTree.getRowForLocation(e.getX(), e.getY());
                boolean enableTodos = true;
                if (row == -1) {
                    enableTodos = false;
                }
                if (e.getButton() == 3) {
                    new JPopupTree(thisTree, enableTodos).show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
    }

    public static interface TreeTransferListener {
        public DefaultMutableTreeNode beforeTransfer(DefaultMutableTreeNode var1);
    }

    protected class JPopupTree
    extends JPopupMenu
    implements ActionListener {
        private JMenuItem expandirTodos;
        private JMenuItem expandirSelecionados;
        private JMenuItem recolherTodos;
        private JMenuItem recolherSelecionados;
        private ContatoTree contatoTree;

        public JPopupTree(ContatoTree contatoTree, boolean enableSelecionados) {
            this.contatoTree = contatoTree;
            this.expandirTodos = new JMenuItem("Expandir Todos");
            this.expandirSelecionados = new JMenuItem("Expandir Selecionados");
            this.recolherTodos = new JMenuItem("Recolher Todos");
            this.recolherSelecionados = new JMenuItem("Recolher selecionados");
            this.expandirSelecionados.addActionListener(this);
            this.expandirTodos.addActionListener(this);
            this.recolherSelecionados.addActionListener(this);
            this.recolherTodos.addActionListener(this);
            this.add(this.expandirSelecionados);
            this.add(this.expandirTodos);
            this.add(this.recolherTodos);
            this.add(this.recolherSelecionados);
            this.recolherSelecionados.setEnabled(enableSelecionados);
            this.expandirSelecionados.setEnabled(enableSelecionados);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.expandirSelecionados)) {
                this.expandirSelecionados();
            } else if (e.getSource().equals(this.expandirTodos)) {
                this.expandirTodos();
            } else if (e.getSource().equals(this.recolherSelecionados)) {
                this.recolherSelecionados();
            } else if (e.getSource().equals(this.recolherTodos)) {
                this.recolherTodos();
            } else if (e.getSource().equals(this.recolherTodos)) {
                ContatoTree.this.selecionarFilhos();
            }
        }

        private void expandirSelecionados() {
            DefaultMutableTreeNode d = (DefaultMutableTreeNode)this.contatoTree.getLastSelectedPathComponent();
            if (d != null) {
                this.contatoTree.expandSelectedNodosTree(d);
            }
        }

        private void expandirTodos() {
            this.contatoTree.expandTree();
        }

        private void recolherSelecionados() {
            DefaultMutableTreeNode d = (DefaultMutableTreeNode)this.contatoTree.getLastSelectedPathComponent();
            if (d != null) {
                this.contatoTree.collapseSelectedNodosTree(d);
            }
        }

        private void recolherTodos() {
            this.contatoTree.collapseTree();
        }
    }
}

