/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoUFException;
import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoCepTextField;
import contato.swing.ContatoFormattedTextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoUfTextField
extends ContatoFormattedTextField {
    String[] uf = new String[]{"AC", "AL", "AP", "BA", "CE", "DF", "ES", "GO", "MS", "MA", "MT", "MS", "MG", "PA", "PB", "PR", "PE", "PI", "RJ", "RN", "RS", "RO", "RR", "SC", "SP", "SE", "TO"};

    public ContatoUfTextField() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String ufChega = ContatoUfTextField.this.getText();
                if (!ContatoUfTextField.this.existeUF(ufChega)) {
                    ContatoUfTextField.this.setText(null);
                }
            }
        });
    }

    @Override
    public Object getValue() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null && !this.existeUF((String)value)) {
            try {
                throw new ContatoUFException();
            }
            catch (ContatoUFException ex) {
                ex.printStackTrace();
            }
        }
        return (String)value;
    }

    private boolean existeUF(String ufChega) {
        for (String str : this.uf) {
            if (!str.equals(ufChega)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getString() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCepTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (String)this.getValue();
    }
}

