/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.table;

import com.touchcomp.basementormedia.ImageProviderFact;
import contato.dialog.ContatoDialogsHelper;
import contato.swing.ContatoButton;
import contato.swing.ContatoPanel;
import contato.swing.ContatoTable;
import contato.swing.ContatoTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RowFilter;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.TableRowSorter;

public class SearchPopup
implements ActionListener,
FocusListener,
ItemListener,
CaretListener,
KeyListener {
    private ContatoTextField textField;
    private ContatoButton btnNext;
    private ContatoButton btnBack;
    private JToggleButton btnFilter;
    private final ContatoTable table;
    private Popup pop;

    public SearchPopup(ContatoTable table) {
        this.table = table;
    }

    public void showPopup() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.textField = new ContatoTextField();
        this.textField.addCaretListener(this);
        this.textField.addKeyListener(this);
        this.textField.setPreferredSize(new Dimension(250, 35));
        ContatoPanel cp = new ContatoPanel(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        cp.add((Component)this.textField, g);
        Dimension d = new Dimension(50, 35);
        this.btnNext = new ContatoButton();
        this.btnNext.setIcon(new ImageIcon(ImageProviderFact.get().getImageNext()));
        this.btnNext.setSize(d);
        this.btnNext.setPreferredSize(d);
        this.btnNext.setMinimumSize(d);
        this.btnBack = new ContatoButton();
        this.btnBack.setIcon(new ImageIcon(ImageProviderFact.get().getImagePrior()));
        this.btnBack.setSize(d);
        this.btnBack.setPreferredSize(d);
        this.btnBack.setMinimumSize(d);
        this.btnFilter = new JToggleButton();
        this.btnFilter.setIcon(new ImageIcon(ImageProviderFact.get().getImageCheck()));
        this.btnFilter.setSize(d);
        this.btnFilter.setPreferredSize(d);
        this.btnFilter.setMinimumSize(d);
        this.btnFilter.addItemListener(this);
        this.btnFilter.setSelected(true);
        this.btnFilter.setEnabled(true);
        this.btnFilter.setFocusable(false);
        g = new GridBagConstraints();
        g.gridx = 2;
        g.gridy = 0;
        cp.add((Component)this.btnFilter, g);
        g = new GridBagConstraints();
        g.gridx = 3;
        g.gridy = 0;
        cp.add((Component)this.btnBack, g);
        g = new GridBagConstraints();
        g.gridx = 4;
        g.gridy = 0;
        cp.add((Component)this.btnNext, g);
        this.pop = PopupFactory.getSharedInstance().getPopup(this.table, cp, p.x, p.y);
        this.textField.addFocusListener(this);
        this.btnBack.addActionListener(this);
        this.btnNext.addActionListener(this);
        this.textField.addActionListener(this);
        cp.repaint();
        cp.validate();
        this.pop.show();
        this.textField.requestFocus();
        this.textField.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnBack)) {
            this.newFilterBack(this.textField.getText());
        }
        if (e.getSource().equals(this.btnFilter)) {
            // empty if block
        }
        if (e.getSource().equals(this.btnNext)) {
            this.newFilterNext();
        }
    }

    private void filter() {
        TableRowSorter sorter = (TableRowSorter)this.table.getRowSorter();
        if (sorter != null) {
            String expr = this.textField.getText();
            sorter.setRowFilter(RowFilter.regexFilter("(?i)" + expr, new int[0]));
            sorter.setSortKeys(null);
        }
    }

    private void newFilterNext() {
        int maxColumn;
        int maxRow;
        boolean achow;
        String regex = this.textField.getText();
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        ++row;
        if (column < 0) {
            ++column;
        }
        if (!(achow = this.selectNext(row, column, regex, maxRow = this.table.getRowCount(), maxColumn = this.table.getColumnCount()))) {
            ContatoDialogsHelper.showInfo("Nenhum registro encontrado.");
        }
    }

    private void newFilterBack(String regex) {
        int maxColumn;
        boolean achow;
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        --row;
        if (column < 0) {
            ++column;
        }
        if (!(achow = this.selectBack(row, column, regex, 0, maxColumn = this.table.getColumnCount()))) {
            ContatoDialogsHelper.showInfo("Nenhum registro encontrado.");
        }
    }

    private boolean selectNext(int row, int column, String regex, int maxRow, int maxColumn) {
        int i = 0;
        int j = 0;
        for (i = 0; i < maxColumn; ++i) {
            for (j = row; j < maxRow; ++j) {
                Object o = this.table.getValueAt(j, i);
                if (o == null || !o.toString().toLowerCase().contains(regex.toLowerCase())) continue;
                this.table.getSelectionModel().setSelectionInterval(j, j);
                this.table.scrollRectToVisible(this.table.getCellRect(this.table.getSelectedRow(), 0, true));
                return true;
            }
        }
        return false;
    }

    private boolean selectBack(int row, int column, String regex, int maxRow, int maxColumn) {
        int i = 0;
        int j = 0;
        for (i = 0; i < maxColumn; ++i) {
            for (j = row; j > maxRow; --j) {
                Object o = this.table.getValueAt(j, i);
                if (o == null || !o.toString().toLowerCase().contains(regex.toLowerCase())) continue;
                this.table.getSelectionModel().setSelectionInterval(j, j);
                this.table.scrollRectToVisible(this.table.getCellRect(this.table.getSelectedRow(), 0, true));
                return true;
            }
        }
        return false;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.btnFilter.isSelected()) {
            this.cancelRowSorter();
        }
        this.pop.hide();
        this.table.requestFocus();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.btnFilter.isSelected()) {
            this.filter();
        } else {
            this.cancelRowSorter();
        }
    }

    private void cancelRowSorter() {
        TableRowSorter sorter = (TableRowSorter)this.table.getRowSorter();
        if (sorter != null) {
            sorter.setRowFilter(null);
            sorter.setSortKeys(null);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.btnFilter.isSelected()) {
            this.filter();
        } else {
            this.cancelRowSorter();
        }
        this.textField.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.newFilterNext();
        }
    }
}

