/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.table.footer;

import contato.swing.ContatoDoubleTextField;
import contato.swing.ContatoLabel;
import contato.swing.ContatoPanel;
import contato.swing.ContatoTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;

public class ContatoTableFooterPanel
extends ContatoPanel
implements ListSelectionListener,
TableColumnModelListener {
    JViewport viewPort;
    ContatoTable table;
    private final int NORMAL_HEIGHT = 20;
    private final int DOUBLE_HEIGHT = 30;

    public ContatoTableFooterPanel(JScrollPane scrollPanel) {
        this.viewPort = scrollPanel.getViewport();
        this.table = (ContatoTable)this.viewPort.getView();
        this.initProps();
    }

    private void initProps() {
        this.setLayout(new GridBagLayout());
        this.table.getColumnModel().addColumnModelListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.buildPanel();
    }

    private void buildPanel(int[] rows) {
        this.removeAll();
        boolean aux = false;
        ContatoLabel lblTotal = new ContatoLabel();
        lblTotal.setText(this.table.getSelectedRowCount() + " / " + this.table.getRowCount());
        Integer gridX = 0;
        Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
        int size = this.table.getColumnModel().getColumnCount();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            Class<?> type = this.table.getModel().getColumnClass(column.getModelIndex());
            JComponent toAdd = null;
            if (type != null && (type.equals(Double.class) || type.equals(Float.class))) {
                Double sum = this.getSum(column, rows);
                ContatoDoubleTextField cd = new ContatoDoubleTextField();
                cd.setFocusable(false);
                cd.setEditable(false);
                cd.setDouble(sum);
                toAdd = cd;
            } else if (gridX == 0) {
                toAdd = lblTotal;
                aux = true;
            } else {
                toAdd = new ContatoLabel();
            }
            toAdd.setPreferredSize(new Dimension(column.getWidth(), 25));
            toAdd.setMinimumSize(new Dimension(column.getWidth(), 25));
            toAdd.setSize(new Dimension(column.getWidth(), 25));
            int weigth = gridX - 1 == size ? 1 : 0;
            GridBagConstraints gb = this.buildGridBagLayout(gridX, 1, weigth, 1, 18);
            this.add((Component)toAdd, gb);
            Integer n = gridX;
            Integer n2 = gridX = Integer.valueOf(gridX + 1);
        }
        Dimension panelSize = this.getDimension(20);
        if (!aux) {
            GridBagConstraints constraints = this.buildGridBagLayout(0, 0, 0, 0, 23);
            this.add((Component)lblTotal, constraints);
        } else {
            panelSize = this.getDimension(30);
        }
        this.setPreferredSize(panelSize);
        this.setMinimumSize(panelSize);
        this.revalidate();
        this.repaint();
    }

    private GridBagConstraints buildGridBagLayout(Integer gridX, Integer gridY, Integer weightX, Integer weightY, Integer anchor) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridX;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.weightx = weightX.intValue();
        gridBagConstraints.weighty = weightY.intValue();
        gridBagConstraints.anchor = anchor;
        return gridBagConstraints;
    }

    private Double getSum(TableColumn column, int[] rows) {
        Double value = 0.0;
        int[] nArray = rows;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer o;
            Integer rowIndex = o = Integer.valueOf(nArray[i]);
            Double found = (Double)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(rowIndex), column.getModelIndex());
            if (found == null) continue;
            value = value + found;
        }
        return value;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.buildPanel();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    private void buildPanel() {
        int[] rows = this.table.getSelectedRows();
        this.buildPanel(rows);
    }

    private Dimension getDimension(int height) {
        Dimension d = this.getSize();
        d.height = height;
        d.width = this.table.getWidth();
        this.setSize(d);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        return d;
    }
}

