/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.texttoolbar;

import contato.dialog.ContatoDialogsHelper;
import contato.swing.ContatoIntegerTextField;
import contato.swing.ContatoTextComponent;
import contato.util.contatofilechooser.ContatoFileChooserUtilities;
import contatocore.util.CoreDownloadFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

public class ContatoBasicTextToolbar
extends JToolBar {
    JTextPane comp;
    private StyledEditorKit editor;

    public ContatoBasicTextToolbar() {
        this.add(this.getBtnBold());
        this.add(this.getBtnItalic());
        this.add(this.getBtnUnderLine());
        this.add(this.getCmbFonts());
        this.add(new JLabel("Tamanho"));
        this.add(this.getFontSizeTextField());
        this.add(this.getBtnAlgimentLeft());
        this.add(this.getBtnAlgimentCenter());
        this.add(this.getBtnAlgimentJustified());
        this.add(this.getBtnAlgimentRigth());
        this.add(this.getBtnChangeForegroundColor());
        this.add(this.getBtnChangeBackgroundColor());
        this.add(this.getBtnPagina());
        this.add(this.getBtnFile());
        this.setAutoscrolls(true);
    }

    public ContatoBasicTextToolbar(JTextPane comp) {
        this();
        this.comp = comp;
    }

    public JButton getBtnBold() {
        JButton btn = new JButton("N");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Negrito");
        btn.addActionListener(new StyledEditorKit.BoldAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ContatoBasicTextToolbar.this.comp.requestFocus();
            }
        });
        return btn;
    }

    public JButton getBtnChangeForegroundColor() {
        JButton btn = new JButton("Cor");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Cor da Fonte");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(null, "Escolha uma cor", Color.yellow);
                if (c != null) {
                    DefaultStyledDocument doc = (DefaultStyledDocument)ContatoBasicTextToolbar.this.comp.getDocument();
                    SimpleAttributeSet sas = new SimpleAttributeSet();
                    StyleConstants.setForeground(sas, c);
                    doc.setCharacterAttributes(ContatoBasicTextToolbar.this.comp.getSelectionStart(), ContatoBasicTextToolbar.this.comp.getSelectionEnd() - ContatoBasicTextToolbar.this.comp.getSelectionStart(), sas, false);
                    ContatoBasicTextToolbar.this.comp.requestFocus();
                }
            }
        });
        return btn;
    }

    public JButton getBtnPagina() {
        JButton btn = new JButton("URL");
        Dimension d = new Dimension(50, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Arquivo a partir de URL");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = ContatoDialogsHelper.showInputDialog("Informe uma URL", "Informe uma URL< Ex: http://www.contatosistemas.com/teste.html>");
                if (url != null && url.trim().length() > 0) {
                    try {
                        File aux = File.createTempFile("dados_versao", ".html");
                        CoreDownloadFile.downloadFileToServer(aux, url);
                        ContatoBasicTextToolbar.this.comp.setPage(aux.toURI().toURL());
                        ContatoBasicTextToolbar.this.comp.requestFocus();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ContatoBasicTextToolbar.class.getName()).log(Level.SEVERE, null, ex);
                        ContatoDialogsHelper.showError("URL inv\u00e1lida!");
                    }
                }
            }
        });
        return btn;
    }

    public JButton getBtnFile() {
        JButton btn = new JButton("Arquivo");
        Dimension d = new Dimension(70, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Arquivo HTML");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = ContatoFileChooserUtilities.getFileToLoad(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith("html") || f.getName().toLowerCase().endsWith("htm");
                    }

                    @Override
                    public String getDescription() {
                        return "Arquivos HTML, HTM";
                    }
                });
                if (f != null) {
                    try {
                        ContatoBasicTextToolbar.this.comp.setPage(f.toURI().toURL());
                        ContatoBasicTextToolbar.this.comp.requestFocus();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ContatoBasicTextToolbar.class.getName()).log(Level.SEVERE, null, ex);
                        ContatoDialogsHelper.showError("Arquivo inv\u00e1lido!");
                    }
                }
            }
        });
        return btn;
    }

    public JButton getBtnChangeBackgroundColor() {
        JButton btn = new JButton("Cor fundo");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Cor da Fonte");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(null, "Escolha uma cor", Color.yellow);
                if (c != null) {
                    DefaultStyledDocument doc = (DefaultStyledDocument)ContatoBasicTextToolbar.this.comp.getDocument();
                    SimpleAttributeSet sas = new SimpleAttributeSet();
                    StyleConstants.setBackground(sas, c);
                    doc.setCharacterAttributes(ContatoBasicTextToolbar.this.comp.getSelectionStart(), ContatoBasicTextToolbar.this.comp.getSelectionEnd() - ContatoBasicTextToolbar.this.comp.getSelectionStart(), sas, false);
                    ContatoBasicTextToolbar.this.comp.requestFocus();
                }
            }
        });
        return btn;
    }

    public JButton getBtnAlgimentLeft() {
        JButton btn = new JButton("L");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Esquerda");
        btn.addActionListener(new StyledEditorKit.AlignmentAction("Left", 0){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ContatoBasicTextToolbar.this.comp.requestFocus();
            }
        });
        return btn;
    }

    public JButton getBtnAlgimentRigth() {
        JButton btn = new JButton("R");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Direita");
        btn.addActionListener(new StyledEditorKit.AlignmentAction("Rigth", 2){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ContatoBasicTextToolbar.this.comp.requestFocus();
            }
        });
        return btn;
    }

    public JButton getBtnAlgimentCenter() {
        JButton btn = new JButton("C");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Centralizado");
        btn.addActionListener(new StyledEditorKit.AlignmentAction("Center", 1){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ContatoBasicTextToolbar.this.comp.requestFocus();
            }
        });
        return btn;
    }

    public JButton getBtnAlgimentJustified() {
        JButton btn = new JButton("J");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Justificado");
        btn.addActionListener(new StyledEditorKit.AlignmentAction("Justified", 3){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ContatoBasicTextToolbar.this.comp.requestFocus();
            }
        });
        return btn;
    }

    public JTextComponent getFontSizeTextField() {
        ContatoIntegerTextField text = new ContatoIntegerTextField();
        text.setValue(10);
        Dimension d = new Dimension(30, 18);
        text.setPreferredSize(d);
        text.setMinimumSize(d);
        text.setMaximumSize(d);
        text.setToolTipText("Tamanho da Fonte");
        text.addFocusListener(new FocusLostFieldFontSize());
        text.addActionListener(new ActionPerformedFieldFontSize());
        return text;
    }

    public JButton getBtnItalic() {
        JButton btn = new JButton("I");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Italico");
        btn.addActionListener(new StyledEditorKit.ItalicAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ContatoBasicTextToolbar.this.comp.requestFocus();
            }
        });
        return btn;
    }

    public JButton getBtnUnderLine() {
        JButton btn = new JButton("U");
        Dimension d = new Dimension(30, 18);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setToolTipText("Sublinhado");
        btn.addActionListener(new StyledEditorKit.UnderlineAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ContatoBasicTextToolbar.this.comp.requestFocus();
            }
        });
        return btn;
    }

    public JComboBox getCmbFonts() {
        JComboBox<Object> cmb = new JComboBox<Object>(this.getFonts());
        Dimension d = new Dimension(80, 18);
        cmb.setPreferredSize(d);
        cmb.setMinimumSize(d);
        cmb.setToolTipText("Fonte");
        cmb.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component tmp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    tmp.setFont(new Font(value.toString(), 0, 14));
                }
                return tmp;
            }
        });
        cmb.addItemListener(new ItemChanged(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JComboBox c = (JComboBox)e.getSource();
                if (c.getSelectedItem() != null) {
                    DefaultStyledDocument doc = (DefaultStyledDocument)ContatoBasicTextToolbar.this.comp.getDocument();
                    SimpleAttributeSet sas = new SimpleAttributeSet();
                    StyleConstants.setFontFamily(sas, c.getSelectedItem().toString());
                    doc.setCharacterAttributes(ContatoBasicTextToolbar.this.comp.getSelectionStart(), ContatoBasicTextToolbar.this.comp.getSelectionEnd() - ContatoBasicTextToolbar.this.comp.getSelectionStart(), sas, false);
                }
            }
        });
        return cmb;
    }

    public void setComp(ContatoTextComponent textComponent1) {
        this.comp = textComponent1;
    }

    public Object[] getFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] fontNames = ge.getAvailableFontFamilyNames();
        return fontNames;
    }

    public StyledEditorKit getEditor() {
        return this.editor;
    }

    public void setEditor(StyledEditorKit editor) {
        this.editor = editor;
    }

    private void changeFontSize(ContatoIntegerTextField e) {
        Integer value = e.getInteger();
        if (value > 0) {
            DefaultStyledDocument doc = (DefaultStyledDocument)this.comp.getDocument();
            SimpleAttributeSet sas = new SimpleAttributeSet();
            StyleConstants.setFontSize(sas, value);
            doc.setCharacterAttributes(doc.getStartPosition().getOffset(), doc.getEndPosition().getOffset(), sas, false);
        }
    }

    class ItemChanged
    implements ItemListener {
        ItemChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setFontFamily(attr, ((JComboBox)e.getSource()).getSelectedItem().toString());
            ContatoBasicTextToolbar.this.comp.requestFocus();
        }
    }

    class ComboFontBox
    extends JComboBox
    implements ListCellRenderer {
        public ComboFontBox(Object[] args) {
            super(args);
            this.setRenderer(this);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel tmp = null;
            if (value != null) {
                tmp = new JLabel(value.toString());
                if (isSelected) {
                    ((Component)tmp).setBackground(list.getSelectionBackground());
                    ((Component)tmp).setForeground(list.getSelectionForeground());
                } else {
                    ((Component)tmp).setBackground(list.getBackground());
                    ((Component)tmp).setForeground(list.getForeground());
                }
            }
            return tmp;
        }
    }

    class FocusLostFieldFontSize
    extends FocusAdapter {
        FocusLostFieldFontSize() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ContatoBasicTextToolbar.this.changeFontSize((ContatoIntegerTextField)e.getSource());
            ContatoBasicTextToolbar.this.comp.requestFocus();
        }
    }

    class ActionPerformedFieldFontSize
    implements ActionListener {
        ActionPerformedFieldFontSize() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContatoBasicTextToolbar.this.changeFontSize((ContatoIntegerTextField)e.getSource());
        }
    }
}

