/*
 * Decompiled with CFR 0.152.
 */
package contato.util.scanner;

import com.touchcomp.basementormedia.ImageProviderFact;
import contato.dialog.ContatoDialogsHelper;
import contato.swing.ContatoButton;
import contato.swing.ContatoScrollPane;
import contato.util.contatofilechooser.ComponentHouseResizer;
import contato.util.contatofilechooser.ContatoFileChooserUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class ScannerUI
extends JDialog
implements ScannerListener {
    private byte[] imagemEscaneada;
    Scanner scanner;
    private ContatoButton contatoButton1;
    private ContatoScrollPane contatoScrollPane1;

    public ScannerUI() throws ScannerIOException {
        this.setModal(true);
        this.initComponents();
        this.scanner = Scanner.getDevice();
        if (this.scanner != null) {
            this.scanner.addListener((ScannerListener)this);
            this.contatoScrollPane1.setViewportView(this.scanner.getScanGUI());
            this.contatoScrollPane1.validate();
        } else {
            this.dispose();
        }
    }

    public static byte[] getImagemFromSource() {
        try {
            ScannerUI d = new ScannerUI();
            d.setTitle("Procure ou escaneie uma imagem");
            d.setSize(183, 230);
            d.setLocationRelativeTo(null);
            d.setModal(true);
            d.setVisible(true);
            d.stop();
            return d.getImagemEscaneada();
        }
        catch (ScannerIOException ex) {
            ex.printStackTrace();
            ContatoDialogsHelper.showError("Erro desconhecido ao iniciar o scanner.");
            return null;
        }
    }

    private void initComponents() {
        this.contatoScrollPane1 = new ContatoScrollPane();
        this.contatoButton1 = new ContatoButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.contatoScrollPane1.setMinimumSize(new Dimension(183, 140));
        this.contatoScrollPane1.setPreferredSize(new Dimension(183, 140));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.contatoScrollPane1, gridBagConstraints);
        this.contatoButton1.setIcon(new ImageIcon(ImageProviderFact.get().getImageFind()));
        this.contatoButton1.setText("Find");
        this.contatoButton1.setMinimumSize(new Dimension(183, 50));
        this.contatoButton1.setPreferredSize(new Dimension(183, 50));
        this.contatoButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScannerUI.this.contatoButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.contatoButton1, gridBagConstraints);
    }

    private void contatoButton1ActionPerformed(ActionEvent evt) {
        try {
            this.setImagemEscaneada(ContatoFileChooserUtilities.getImageFromFile(true, null));
            this.dispose();
        }
        catch (IOException ex) {
            ContatoDialogsHelper.showError("Erro ao ler a imagem do arquivo.");
        }
    }

    public void stop() {
        if (this.scanner != null) {
            // empty if block
        }
    }

    private byte[] convertImage(BufferedImage img) {
        try {
            File temp = File.createTempFile("image", ".png");
            ImageIO.write((RenderedImage)img, "jpeg", temp);
            return ComponentHouseResizer.getInstance().processImage(temp.getAbsolutePath(), true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public byte[] getImagemEscaneada() {
        return this.imagemEscaneada;
    }

    public void setImagemEscaneada(byte[] imagemEscaneada) {
        this.imagemEscaneada = imagemEscaneada;
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata siom) {
        if (type.equals(ScannerIOMetadata.ACQUIRED)) {
            this.setImagemEscaneada(this.convertImage(siom.getImage()));
            this.dispose();
        } else if (type.equals(ScannerIOMetadata.FILE)) {
            try {
                File file = siom.getFile();
                this.setImagemEscaneada(ComponentHouseResizer.getInstance().processImage(file.getAbsolutePath(), true));
                this.dispose();
            }
            catch (IOException ex) {
                ContatoDialogsHelper.showError("Erro ao procurar a imagem no arquivo.");
                Logger.getLogger(ScannerUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (!type.equals(ScannerIOMetadata.NEGOTIATE)) {
            if (type.equals(ScannerIOMetadata.STATECHANGE)) {
                siom.getState();
                System.out.println("Scanner State " + siom.getStateStr());
            } else if (type.equals(ScannerIOMetadata.INFO)) {
                System.out.println(siom.getInfo());
                ContatoDialogsHelper.showError(siom.getInfo());
            } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
                System.out.println(siom.getException());
                ContatoDialogsHelper.showError("Ocorreu um erro desconhecido ao escanear a imagem.");
            }
        }
    }
}

