/*
 * Decompiled with CFR 0.152.
 */
package contatocore.listeners;

import contatocore.listeners.TreeSelectionManipulation;
import contatocore.util.UtilObservacoes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.persistence.Entity;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NodeSelectionListener
extends MouseAdapter {
    private JTree tree;
    private TreeSelectionManipulation treeSelectionManipulation;

    public NodeSelectionListener(JTree tree, TreeSelectionManipulation treeSelectionManipulation) {
        this.tree = tree;
        this.treeSelectionManipulation = treeSelectionManipulation;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this.tree.getSelectionPath();
        this.createTree(path);
        this.showPopupOnTree(e, path);
    }

    private void showPopupOnTree(MouseEvent e, TreePath path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode d = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!d.isLeaf()) {
            return;
        }
        Class c = (Class)d.getUserObject();
        if (c.getPackage() != null && c.getPackage().getName().contains("model.vo")) {
            return;
        }
        this.createPopUP(e, path);
    }

    private void createPopUP(MouseEvent e, final TreePath path) {
        JPopupMenu jp = new JPopupMenu();
        JMenuItem add = new JMenuItem("Adicionar");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NodeSelectionListener.this.treeSelectionManipulation != null) {
                    NodeSelectionListener.this.treeSelectionManipulation.addObjectToTree(NodeSelectionListener.this.getFullPath(path), NodeSelectionListener.this.getSelectionClass(path));
                }
            }
        });
        jp.add(add);
        JMenuItem sum = new JMenuItem("Soma");
        sum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeSelectionListener.this.treeSelectionManipulation.addObjectToTree("|sum|" + NodeSelectionListener.this.getFullPath(path), NodeSelectionListener.this.getSelectionClass(path));
            }
        });
        if (this.getSelectionClass(path).equals(Double.class)) {
            jp.add(sum);
        }
        jp.show(this.tree, e.getX() + 20, e.getY());
    }

    private String getFullPath(TreePath path) {
        String fullPath = null;
        for (DefaultMutableTreeNode lastPath = (DefaultMutableTreeNode)path.getLastPathComponent(); lastPath != null && lastPath.getParent() != null; lastPath = (DefaultMutableTreeNode)lastPath.getParent()) {
            fullPath = fullPath == null ? lastPath.toString() : lastPath.toString() + "." + fullPath;
        }
        return fullPath;
    }

    private Class getSelectionClass(TreePath path) {
        DefaultMutableTreeNode lastPath = (DefaultMutableTreeNode)path.getLastPathComponent();
        return (Class)lastPath.getUserObject();
    }

    private void createTree(TreePath path) {
        Class ch;
        DefaultMutableTreeNode node;
        if (path != null && !(node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject().getClass().equals(String.class) && (ch = (Class)node.getUserObject()).getAnnotation(Entity.class) != null) {
            DefaultMutableTreeNode child = UtilObservacoes.buildObservacaoTree(ch);
            for (int i = 0; i < child.getChildCount(); ++i) {
                node.add((DefaultMutableTreeNode)child.getChildAt(i));
            }
        }
    }
}

