/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.util.ContatoStringUtil;
import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class ContatoDateUtil
implements Serializable {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DD_MM_YYYY = "dd-MM-yyyy";
    public static final String DD_MM_YYYY_SQL = "dd.MM.yyyy";
    public static final String DD_MM_YYYY_SQL_DATABASE = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_CLASSIC = "yyyy/MM/dd";
    public static final String DD_MM_YYYY_CLASSIC = "dd/MM/yyyy";
    public static final String DD_MM_YYYY_HH_MM = "dd/MM/yyyy-HH:mm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String DD_MM_YYYY_HH_MM_SS = "dd/MM/yyyy-HH:mm:ss";
    public static final String DD_MM_YYYY_HH_MM_SS_SQL = "dd.MM.yyyy, HH:mm:ss";
    public static final String DD_MM_YYYY_HH_MM_SS_SQL_DATABASE = "yyyy-MM-dd HH:mm:ss";
    public static final String DD_MM_YYYY_HH_MM_SPACE = "dd/MM/yyyy HH:mm";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String HH_MM = "HH:mm";
    public static final String MM_YYYY = "MM/yyyy";
    public static final Locale PT_BR_LOCALE = new Locale("pt", "BR", "ISO8859-1");
    public static final int DIAS_JANEIRO = 31;
    public static final int DIAS_FEVEREIRO_NORMAL = 28;
    public static final int DIAS_FEVEREIRO_BISSEXTO = 29;
    public static final int DIAS_MARCO = 31;
    public static final int DIAS_ABRIL = 30;
    public static final int DIAS_MAIO = 31;
    public static final int DIAS_JUNHO = 30;
    public static final int DIAS_JULHO = 31;
    public static final int DIAS_AGOSTO = 31;
    public static final int DIAS_SETEMBRO = 30;
    public static final int DIAS_OUTUBRO = 31;
    public static final int DIAS_NOVEMBRO = 30;
    public static final int DIAS_DEZEMBRO = 31;

    public static int getLastDayOnMonth(int year, int month) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, year);
        g.set(2, month);
        return g.getActualMaximum(5);
    }

    public static boolean isHorarioVerao() {
        Calendar c = Calendar.getInstance(TimeZone.getDefault());
        c.setTime(new Date());
        int offset = c.get(16);
        return offset != 0;
    }

    public static Date strToDate(String strDate) {
        return ContatoDateUtil.strToDate(strDate, DD_MM_YYYY_CLASSIC);
    }

    public static Date strToDate(String strDate, String pattern) {
        try {
            if (strDate != null && pattern != null) {
                Date tempDate = null;
                SimpleDateFormat sd = new SimpleDateFormat(pattern, PT_BR_LOCALE);
                if (ContatoStringUtil.refina(strDate).length() == 0) {
                    return null;
                }
                tempDate = sd.parse(strDate);
                return tempDate;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("Erro ao converter a Data");
        }
    }

    public static String dateToStr(Date date) {
        return ContatoDateUtil.dateToStr(date, 2);
    }

    public static Date strToDate(String strDate, int dateFormat) {
        try {
            if (strDate != null) {
                Date tempDate;
                DateFormat d = DateFormat.getDateInstance(dateFormat, PT_BR_LOCALE);
                if (!d.format(tempDate = d.parse(strDate)).equals(strDate)) {
                    throw new ParseException("", 5);
                }
                return tempDate;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("N\u00e3o foi poss\u00edvel converter o texto " + strDate + " em data");
        }
    }

    public static String dateToStr(Date date, int dateFormat) {
        if (date != null) {
            return DateFormat.getDateInstance(dateFormat, PT_BR_LOCALE).format(date);
        }
        return null;
    }

    public static Date formatDate(Date d, int dateFormat) {
        try {
            if (d != null) {
                String strHoje = ContatoDateUtil.dateToStr(d);
                Date hoje = DateFormat.getDateInstance(dateFormat, PT_BR_LOCALE).parse(strHoje);
                return hoje;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return d;
        }
    }

    public static Date formatDate(Date date) {
        return ContatoDateUtil.formatDate(date, 2);
    }

    public static String dateToStr(Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat sd = new SimpleDateFormat(pattern, PT_BR_LOCALE);
            return sd.format(date);
        }
        return null;
    }

    public static boolean comparaMesAno(String data1, String data2) {
        String data1Str = data1.substring(data1.indexOf("/") + 1);
        String data2Str = data2.substring(data2.indexOf("/") + 1);
        return data1Str.equals(data2Str);
    }

    public static Date nextPreviousDays(Date dataAtual, int numDias) {
        long oneDay = 86400000L;
        long dataAtualMili = dataAtual.getTime();
        long dataFuturaMili = dataAtualMili + (long)numDias * oneDay;
        Date dataFutura = new Date(dataFuturaMili);
        return dataFutura;
    }

    public static Date nextPreviousHours(Date dataAtual, int numHoras) {
        Calendar date = Calendar.getInstance();
        date.setTime(dataAtual);
        date.add(10, numHoras);
        return date.getTime();
    }

    public static java.sql.Date toSQLDate(Date data) {
        try {
            long dataLong = data.getTime();
            return new java.sql.Date(dataLong);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getFirstDayMonth(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getLastDayMonth(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Timestamp toTimestamp(Date data) {
        try {
            long dataLong = data.getTime();
            return new Timestamp(dataLong);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Timestamp toTimestamp(Date data, Date time) {
        try {
            Calendar dateCalendar = ContatoDateUtil.toCalendar(data);
            Calendar timeCalendar = ContatoDateUtil.toCalendar(time);
            dateCalendar.set(11, timeCalendar.get(11));
            dateCalendar.set(12, timeCalendar.get(12));
            dateCalendar.set(13, timeCalendar.get(13));
            return new Timestamp(dateCalendar.getTime().getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar toCalendar(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        return calendar;
    }

    public static Date nextDateInNextMonth(Date data, Date dataBase) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar1 = Calendar.getInstance();
        calendar.setTime(data);
        calendar1.setTime(dataBase);
        int month = calendar.get(2);
        int year = calendar.get(1);
        if (month + 1 > 11) {
            month = 0;
            ++year;
        } else {
            ++month;
        }
        int dayOfMonth = calendar.get(5);
        int dayOfMonth1 = calendar1.get(5);
        if (dayOfMonth != dayOfMonth1) {
            dayOfMonth = dayOfMonth1;
        }
        if (dayOfMonth > ContatoDateUtil.getLastDayOnMonth(year, month)) {
            dayOfMonth = ContatoDateUtil.getLastDayOnMonth(year, month);
        }
        calendar.set(2, month);
        calendar.set(1, year);
        calendar.set(5, dayOfMonth);
        return calendar.getTime();
    }

    public static Date nextDateInNextMonth(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        int month = calendar.get(2);
        calendar.set(2, month + 1);
        return calendar.getTime();
    }

    public static Date toTime(Date data) {
        long dataLong = data.getTime();
        Time time = new Time(dataLong);
        return new java.sql.Date(time.getTime());
    }

    public static String getDayInMonthDescription(Date date) {
        String dia = ContatoDateUtil.dateToStr(date, "dd");
        return ContatoDateUtil.getDayInMonthDescription(dia);
    }

    public static String toStrMonth(Date date) {
        String mes = ContatoDateUtil.dateToStr(date, "MM");
        return ContatoDateUtil.toStrMonth(mes);
    }

    public static String getDayInMonthDescription(String dia) {
        if (Integer.parseInt(dia) > 31 || Integer.parseInt(dia) <= 0) {
            throw new IllegalArgumentException("Dia inv\u00e1lido");
        }
        HashMap<String, String> dias = new HashMap<String, String>();
        dias.put("01", "um");
        dias.put("02", "dois");
        dias.put("03", "tr\u00eas");
        dias.put("04", "quatro");
        dias.put("05", "cinco");
        dias.put("06", "seis");
        dias.put("07", "sete");
        dias.put("08", "oito");
        dias.put("09", "nove");
        dias.put("10", "dez");
        dias.put("11", "onze");
        dias.put("12", "doze");
        dias.put("13", "treze");
        dias.put("14", "quatorze");
        dias.put("16", "dezesseis");
        dias.put("17", "dezessete");
        dias.put("18", "dezoito");
        dias.put("19", "dezenove");
        dias.put("20", "vinte");
        dias.put("21", "vinte e um");
        dias.put("22", "vinte e dois");
        dias.put("23", "vinte e tr\u00eas");
        dias.put("24", "vinte e quatro");
        dias.put("25", "vinte e cinco");
        dias.put("26", "vinte e seis");
        dias.put("27", "vinte e sete");
        dias.put("28", "vinte e oito");
        dias.put("29", "vinte e nove");
        dias.put("30", "trinta");
        dias.put("31", "trinta e um");
        return (String)dias.get(dia);
    }

    public static String toStrMonth(String mes) {
        if (Integer.parseInt(mes) > 12 || Integer.parseInt(mes) <= 0) {
            throw new IllegalArgumentException("Mes inv\u00e1lido");
        }
        HashMap<String, String> dias = new HashMap<String, String>();
        dias.put("01", "janeiro");
        dias.put("02", "fevereiro");
        dias.put("03", "mar\u00e7o");
        dias.put("04", "abril");
        dias.put("05", "maio");
        dias.put("06", "junho");
        dias.put("07", "julho");
        dias.put("08", "agosto");
        dias.put("09", "setembro");
        dias.put("10", "outubro");
        dias.put("11", "novembro");
        dias.put("12", "dezembro");
        return (String)dias.get(mes);
    }

    public static Integer yearFromDate(Object obj) {
        if (obj instanceof Date) {
            String data = ContatoDateUtil.dateToStr((Date)obj);
            return new Integer(data.substring(6));
        }
        if (obj instanceof java.sql.Date) {
            String data = ContatoDateUtil.dateToStr(new Date(((java.sql.Date)obj).getTime()));
            return new Integer(data.substring(6));
        }
        return -1;
    }

    public static Integer getTotalDaysInMonth(Date dataBaixa) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dataBaixa);
        return ((Calendar)calendar).getActualMaximum(5);
    }
}

