/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.exceptions.ContatoFTPException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.TrustManagerUtils;

public class ContatoFTPSUtilities {
    public void useFTP(String ftpserver, String pathDirectory, String pathFileToUpload, String fileName, String username, String password) throws ContatoFTPException {
        boolean isImpicit = false;
        String protocol = "TLS";
        FileInputStream input = null;
        FTPSClient ftpClient = new FTPSClient(protocol, isImpicit);
        try {
            ftpClient.enterLocalPassiveMode();
            ftpClient.setRemoteVerificationEnabled(false);
            ftpClient.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
            ftpClient.connect(ftpserver);
            System.out.print(ftpClient.getReplyString());
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                ftpClient.disconnect();
                System.out.println("Connection refused.");
                throw new ContatoFTPException("Connection refused");
            }
            ftpClient.login(username, password);
            ftpClient.execPBSZ(0L);
            ftpClient.execPROT("P");
            this.createDirectory(pathDirectory, (FTPClient)ftpClient);
            ftpClient.setFileType(2);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            input = new FileInputStream(pathFileToUpload);
            ftpClient.enterLocalPassiveMode();
            ftpClient.storeFile(fileName, (InputStream)input);
            ftpClient.logout();
        }
        catch (IOException e) {
            System.out.println(ftpClient.getReplyStrings());
            e.printStackTrace();
            throw new ContatoFTPException("Connection refused", e);
        }
        finally {
            try {
                ftpClient.disconnect();
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                throw new ContatoFTPException("Connection refused", ex);
            }
        }
    }

    public void downloadFileFTP(String ftpserver, String localStoreFile, String pathFileToDownload, String username, String password) throws ContatoFTPException {
        FTPClient ftpClient = new FTPClient();
        FileOutputStream output = null;
        try {
            ftpClient.connect(ftpserver);
            System.out.print(ftpClient.getReplyString());
            ftpClient.enterLocalPassiveMode();
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                ftpClient.disconnect();
                System.out.println("Connection refused.");
                throw new ContatoFTPException("Connection refused");
            }
            ftpClient.login(username, password);
            this.changeDirectory(pathFileToDownload, ftpClient);
            String fileName = pathFileToDownload.substring(pathFileToDownload.lastIndexOf("/") + 1);
            ftpClient.setFileType(2);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            output = new FileOutputStream(localStoreFile);
            ftpClient.retrieveFile(fileName, (OutputStream)output);
            output.flush();
            output.close();
            ftpClient.logout();
        }
        catch (IOException e) {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ContatoFTPException("Connection refused", e);
        }
        finally {
            try {
                ftpClient.disconnect();
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                throw new ContatoFTPException("Connection refused", ex);
            }
        }
    }

    private void createDirectory(String pathDirectory, FTPClient ftp) throws IOException {
        StringTokenizer st = new StringTokenizer(pathDirectory, "/");
        ftp.printWorkingDirectory();
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (ftp.changeWorkingDirectory(tk)) continue;
            ftp.makeDirectory(tk);
            ftp.changeWorkingDirectory(tk);
        }
        ftp.printWorkingDirectory();
    }

    private void changeDirectory(String pathDirectory, FTPClient ftp) throws IOException {
        StringTokenizer st = new StringTokenizer(pathDirectory, "/");
        int i = 0;
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            ++i;
            if (st.countTokens() <= 0) continue;
            ftp.changeWorkingDirectory(tk);
        }
        ftp.printWorkingDirectory();
    }
}

