/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.exceptions.ContatoFTPException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class ContatoFTPUtilities {
    public void useFTP(String ftpserver, String pathDirectory, String pathFileToUpload, String fileName, String username, String password) throws ContatoFTPException {
        FTPClient ftpClient = new FTPClient();
        FileInputStream input = null;
        try {
            ftpClient.connect(ftpserver, 21);
            System.out.print(ftpClient.getReplyString());
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                ftpClient.disconnect();
                System.out.println("Connection refused.");
                throw new ContatoFTPException("Connection refused");
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.enterRemotePassiveMode();
            ftpClient.login(username, password);
            this.createDirectory(pathDirectory, ftpClient);
            ftpClient.setFileType(2);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            input = new FileInputStream(pathFileToUpload);
            ftpClient.storeFile(fileName, (InputStream)input);
            ftpClient.logout();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ContatoFTPException("Connection refused", e);
        }
        finally {
            try {
                ftpClient.disconnect();
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                throw new ContatoFTPException("Connection refused", ex);
            }
        }
    }

    public void downloadFileFTP(String ftpserver, String localStoreFile, String pathFileToDownload, String username, String password) throws ContatoFTPException {
        FTPClient ftpClient = new FTPClient();
        FileOutputStream output = null;
        try {
            ftpClient.connect(ftpserver);
            System.out.print(ftpClient.getReplyString());
            ftpClient.enterLocalPassiveMode();
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                ftpClient.disconnect();
                System.out.println("Connection refused.");
                throw new ContatoFTPException("Connection refused");
            }
            ftpClient.login(username, password);
            this.changeDirectory(pathFileToDownload, ftpClient);
            String fileName = pathFileToDownload.substring(pathFileToDownload.lastIndexOf("/") + 1);
            ftpClient.setFileType(2);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            output = new FileOutputStream(localStoreFile);
            ftpClient.retrieveFile(fileName, (OutputStream)output);
            output.flush();
            output.close();
            ftpClient.logout();
        }
        catch (IOException e) {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ContatoFTPException("Connection refused", e);
        }
        finally {
            try {
                ftpClient.disconnect();
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                throw new ContatoFTPException("Connection refused", ex);
            }
        }
    }

    private void createDirectory(String pathDirectory, FTPClient ftp) throws IOException {
        StringTokenizer st = new StringTokenizer(pathDirectory, "/");
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (ftp.changeWorkingDirectory(tk)) continue;
            ftp.makeDirectory(tk);
            ftp.changeWorkingDirectory(tk);
        }
        ftp.printWorkingDirectory();
    }

    private void changeDirectory(String pathDirectory, FTPClient ftp) throws IOException {
        StringTokenizer st = new StringTokenizer(pathDirectory, "/");
        int i = 0;
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            ++i;
            if (st.countTokens() <= 0) continue;
            ftp.changeWorkingDirectory(tk);
        }
        ftp.printWorkingDirectory();
    }
}

