/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.util.ContatoStringUtil;
import contatocore.util.DadosPorExtenso;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import org.brazilutils.br.cpfcnpj.CpfCnpj;
import org.brazilutils.br.uf.UF;
import org.brazilutils.br.uf.ie.InscricaoEstadual;
import org.brazilutils.utilities.NumberComposedMasker;

public class ContatoFormatUtil {
    public static String formataNumero(Number numero, int casasDecimais, int casasInteiras) {
        NumberFormat n = NumberFormat.getNumberInstance();
        n.setMaximumFractionDigits(casasDecimais);
        n.setMinimumFractionDigits(casasDecimais);
        n.setMaximumIntegerDigits(casasInteiras);
        if (casasInteiras > 0) {
            n.setMinimumIntegerDigits(casasInteiras);
        }
        if (numero == null) {
            numero = 0.0;
        }
        return n.format(new Double(numero.toString()));
    }

    public static String formataNumero(Number numero, int casasDecimais) {
        NumberFormat n = NumberFormat.getNumberInstance();
        n.setMaximumFractionDigits(casasDecimais);
        n.setMinimumFractionDigits(casasDecimais);
        return n.format(new Double(numero.toString()));
    }

    public static String dataPorExtenso(Date data) {
        return DadosPorExtenso.dataPorExtenso(data);
    }

    public static String dataPorExtensoSomenteMes(Date data) {
        return DadosPorExtenso.dataPorExtensoSomenteMes(data);
    }

    public static String numeroPorExtenso(Number num) {
        return DadosPorExtenso.numeroPorExtenso(num);
    }

    public static String numeroPorExtensoReais(Number num) {
        return DadosPorExtenso.numeroPorExtensoReais(num);
    }

    private static String clearEspacosInicioFim(StringBuilder sb) {
        if (sb.length() > 0) {
            int i = 0;
            while (sb.charAt(i) == ' ') {
                ++i;
            }
            String result = sb.substring(i);
            i = sb.length() - 1;
            while (sb.charAt(i) == ' ') {
                --i;
            }
            result = sb.substring(0, i + 1);
            return result;
        }
        return sb.toString();
    }

    public static String formatarNumero(Locale ENGLISH, Float num, int decimalSize) {
        DecimalFormat form = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        form.applyLocalizedPattern("###0.00");
        form.setMaximumFractionDigits(decimalSize);
        form.setMinimumFractionDigits(decimalSize);
        form.setMaximumIntegerDigits(15);
        return form.format(new Double(num.toString()));
    }

    public static Float truncarValor(Float aFloat, int decimalSize) {
        if (aFloat == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(ContatoFormatUtil.arrredondarNumero(new Double(aFloat.toString()), decimalSize, 3).floatValue());
    }

    public static Double truncarValor(Double aFloat, int decimalSize) {
        if (aFloat == null) {
            return 0.0;
        }
        return (double)Math.round(aFloat * 100.0) / 100.0;
    }

    public static void main(String[] args) {
        float nr = 12.735f;
        System.out.println("Celling" + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 2));
        System.out.println("Down" + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 1));
        System.out.println("Floor: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 3));
        System.out.println("half down: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 5));
        System.out.println("Even: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 6));
        System.out.println("half UP: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 4));
        System.out.println("UP: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 0));
        nr = 12.745f;
        System.out.println("Celling" + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 2));
        System.out.println("Down" + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 1));
        System.out.println("Floor: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 3));
        System.out.println("half down: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 5));
        System.out.println("Even: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 6));
        System.out.println("half UP: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 4));
        System.out.println("UP: " + ContatoFormatUtil.arrredondarNumero(Float.valueOf(nr), 2, 0));
    }

    public static float arrredondarNumero(Float numero, int casasDec) {
        try {
            if (numero == null) {
                return 0.0f;
            }
            BigDecimal big = new BigDecimal(numero.floatValue());
            big = big.setScale(casasDec, 6);
            return big.floatValue();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static float arrredondarNumero(Float numero, int casasDec, int mode) {
        try {
            if (numero == null) {
                return 0.0f;
            }
            BigDecimal big = new BigDecimal(numero.floatValue());
            big = big.setScale(casasDec, mode);
            return big.floatValue();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static Double arrredondarNumero(Double numero, int casasDec, int mode) {
        try {
            if (numero == null) {
                return 0.0;
            }
            BigDecimal big = new BigDecimal(numero);
            big = big.setScale(casasDec, mode);
            return big.doubleValue();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static Double arrredondarNumero(Double numero, int casasDec) {
        try {
            if (numero == null) {
                return 0.0;
            }
            BigDecimal big = new BigDecimal(numero);
            big = big.setScale(casasDec, 6);
            return big.doubleValue();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static BigDecimal arrredondarNumeroBigDecimal(Double numero, int casasDec) {
        try {
            if (numero == null) {
                return new BigDecimal(0.0);
            }
            BigDecimal big = new BigDecimal(numero);
            big = big.setScale(casasDec, 6);
            return big;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new BigDecimal(0.0);
        }
    }

    public static String formatIE(String ufChega, String ieChega) {
        try {
            if (ieChega != null && ieChega.length() >= 5) {
                UF uf = UF.valueOf((String)ufChega);
                InscricaoEstadual ie = uf.getInscricaoEstadual();
                if (ufChega.equalsIgnoreCase("AM")) {
                    return NumberComposedMasker.applyMask((String)ContatoStringUtil.refina(ieChega), (String)"##.###.###-#");
                }
                return NumberComposedMasker.applyMask((String)ContatoStringUtil.refina(ieChega), (String)ie.getMask());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatCNPJCPF(String cadastro) {
        try {
            if (cadastro.length() > 10) {
                CpfCnpj c = new CpfCnpj(cadastro);
                return NumberComposedMasker.applyMask((String)ContatoStringUtil.refina(cadastro), (String)c.getMask());
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String completaZeros(String account, int num, boolean completaLado) {
        String teste = "";
        for (int i = 0; i < num - account.length(); ++i) {
            teste = teste + "0";
        }
        if (completaLado) {
            return teste + account;
        }
        return account + teste;
    }

    public static String completaCaracteres(String account, int num, boolean completaLado, String caractere) {
        String teste = "";
        for (int i = 0; i < num - account.length(); ++i) {
            teste = teste + caractere;
        }
        if (completaLado) {
            return teste + account;
        }
        return account + teste;
    }

    public static String completaZerosDireita(String value, int num) {
        if (value != null) {
            return ContatoFormatUtil.completaZeros(value, num, false);
        }
        return null;
    }

    public static String completaZerosEsquerda(String value, int num) {
        if (value != null) {
            return ContatoFormatUtil.completaZeros(value, num, true);
        }
        return null;
    }

    public static String clearStringXml(String toClear) {
        if (toClear == null) {
            return "";
        }
        char[] c = toClear.toCharArray();
        StringBuilder sb = new StringBuilder();
        char lastChar = ' ';
        for (int i = 0; i < c.length; ++i) {
            char a = c[i];
            char ch = a;
            if (ch >= '(' && ch <= ';') {
                sb.append(a);
            } else if (ch == '=') {
                sb.append(a);
            } else if (ch >= '@' && ch <= 'Z') {
                sb.append(a);
            } else if (ch == '_') {
                sb.append(a);
            } else if (ch >= 'a' && ch <= 'z') {
                sb.append(a);
            } else if (ch == '\u00b7' && ch <= '\u00b8') {
                sb.append(a);
            } else if (ch == '\u00c7') {
                sb.append('C');
            } else if (ch == '\u00e7') {
                sb.append('c');
            } else if (ch >= '\u00c0' && ch <= '\u00c5') {
                sb.append('A');
            } else if (ch >= '\u00c9' && ch <= '\u00cb') {
                sb.append('E');
            } else if (ch >= '\u00cc' && ch <= '\u00cf') {
                sb.append('I');
            } else if (ch >= '\u00d2' && ch <= '\u00d6') {
                sb.append('O');
            } else if (ch >= '\u00d9' && ch <= '\u00dc') {
                sb.append('U');
            } else if (ch >= '\u00e0' && ch <= '\u00e4') {
                sb.append('a');
            } else if (ch >= '\u00e8' && ch <= '\u00eb') {
                sb.append('e');
            } else if (ch >= '\u00ec' && ch <= '\u00ef') {
                sb.append('i');
            } else if (ch >= '\u00f2' && ch <= '\u00ec') {
                sb.append('o');
            } else if (ch >= '\u00f9' && ch <= '\u00fc') {
                sb.append('u');
            } else if (lastChar != ' ') {
                a = ' ';
                sb.append(a);
            }
            lastChar = a;
        }
        return ContatoFormatUtil.clearEspacosInicioFim(sb);
    }

    public static String clearStringNumberXml(String toClear) {
        if (toClear == null) {
            return "";
        }
        char[] c = toClear.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            char a = c[i];
            char ch = a;
            if (ch < '0' || ch > '9') continue;
            sb.append(a);
        }
        return sb.toString();
    }
}

