/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;

public class ContatoFormatterUtil {
    private static DefaultFormatterFactory defaultFloatFormatter = null;
    private static DefaultFormatterFactory defaultDoubleFormatter = null;
    private static DefaultFormatterFactory defaultShortFormatter = null;
    private static DefaultFormatterFactory integerFormatterFactory = null;
    private static DefaultFormatterFactory fixedIntegerMask = null;
    private static DefaultFormatterFactory cpfMask = null;
    private static DefaultFormatterFactory cnpjMask = null;
    private static DefaultFormatterFactory cepMask = null;
    private static DefaultFormatterFactory longFormatterFactory = null;

    public static DefaultFormatterFactory getLongFormatter(int digits) {
        DefaultFormatterFactory aux = new DefaultFormatterFactory();
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(0);
        format.setMinimumFractionDigits(0);
        format.setMaximumIntegerDigits(16);
        format.setMinimumIntegerDigits(0);
        format.setParseIntegerOnly(true);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Long.class);
        aux.setDefaultFormatter(formatter);
        aux.setDisplayFormatter(formatter);
        aux.setEditFormatter(formatter);
        return aux;
    }

    public static DefaultFormatterFactory getDefaultFloatFormatter() {
        if (defaultFloatFormatter == null) {
            defaultFloatFormatter = new DefaultFormatterFactory();
            NumberFormat format = ContatoFormatterUtil.getNumberFormat();
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(2);
            format.setMaximumIntegerDigits(12);
            format.setMinimumIntegerDigits(1);
            NumberFormatter formatter = new NumberFormatter(format);
            formatter.setValueClass(Float.class);
            defaultFloatFormatter.setDefaultFormatter(formatter);
            defaultFloatFormatter.setDisplayFormatter(formatter);
            defaultFloatFormatter.setEditFormatter(formatter);
        }
        return defaultFloatFormatter;
    }

    public static DefaultFormatterFactory getDefaultShortFormatter() {
        if (defaultShortFormatter == null) {
            defaultShortFormatter = new DefaultFormatterFactory();
            NumberFormat format = ContatoFormatterUtil.getNumberFormat();
            format.setMaximumFractionDigits(0);
            format.setMinimumFractionDigits(0);
            format.setMaximumIntegerDigits(9);
            format.setMinimumIntegerDigits(1);
            NumberFormatter formatter = new NumberFormatter(format);
            formatter.setValueClass(Short.class);
            defaultShortFormatter.setDefaultFormatter(formatter);
            defaultShortFormatter.setDisplayFormatter(formatter);
            defaultShortFormatter.setEditFormatter(formatter);
        }
        return defaultShortFormatter;
    }

    public static NumberFormat getNumberFormat() {
        NumberFormat format = NumberFormat.getNumberInstance();
        return format;
    }

    public static DefaultFormatterFactory getDefaultDoubleFormatter() {
        if (defaultDoubleFormatter == null) {
            defaultDoubleFormatter = new DefaultFormatterFactory();
            NumberFormat format = ContatoFormatterUtil.getNumberFormat();
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(2);
            format.setMaximumIntegerDigits(9);
            format.setMinimumIntegerDigits(1);
            NumberFormatter formatter = new NumberFormatter(format);
            formatter.setValueClass(Double.class);
            defaultDoubleFormatter.setDefaultFormatter(formatter);
            defaultDoubleFormatter.setDisplayFormatter(formatter);
            defaultDoubleFormatter.setEditFormatter(formatter);
        }
        return defaultDoubleFormatter;
    }

    public static DefaultFormatterFactory getFloatFormatterDecimalSize(int decimalSize) {
        DefaultFormatterFactory numericFormatterFactory = new DefaultFormatterFactory();
        NumberFormat format = ContatoFormatterUtil.getNumberFormat();
        format.setMaximumFractionDigits(decimalSize);
        format.setMinimumFractionDigits(decimalSize);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Float.class);
        numericFormatterFactory.setDefaultFormatter(formatter);
        numericFormatterFactory.setDisplayFormatter(formatter);
        numericFormatterFactory.setEditFormatter(formatter);
        return numericFormatterFactory;
    }

    public static DefaultFormatterFactory getDoubleFormatterDecimalSize(int decimalSize) {
        DefaultFormatterFactory f = new DefaultFormatterFactory();
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(decimalSize);
        format.setMinimumFractionDigits(decimalSize);
        format.setMaximumIntegerDigits(9);
        format.setMinimumIntegerDigits(1);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Double.class);
        f.setDefaultFormatter(formatter);
        f.setDisplayFormatter(formatter);
        f.setEditFormatter(formatter);
        return f;
    }

    public static DefaultFormatterFactory getDefaultIntegerFormatter() {
        if (integerFormatterFactory == null) {
            integerFormatterFactory = new DefaultFormatterFactory();
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setMaximumFractionDigits(0);
            format.setMinimumFractionDigits(0);
            format.setMaximumIntegerDigits(9);
            format.setMinimumIntegerDigits(0);
            format.setParseIntegerOnly(true);
            NumberFormatter formatter = new NumberFormatter(format);
            formatter.setValueClass(Integer.class);
            integerFormatterFactory.setDefaultFormatter(formatter);
            integerFormatterFactory.setDisplayFormatter(formatter);
            integerFormatterFactory.setEditFormatter(formatter);
            integerFormatterFactory.setNullFormatter(formatter);
        }
        return integerFormatterFactory;
    }

    public static DefaultFormatterFactory getIntegerFormatterDigits(int integerDigits) {
        DefaultFormatterFactory aux = new DefaultFormatterFactory();
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setMaximumFractionDigits(0);
        format.setMinimumFractionDigits(0);
        format.setMaximumIntegerDigits(integerDigits);
        format.setMinimumIntegerDigits(0);
        format.setParseIntegerOnly(true);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        aux.setDefaultFormatter(formatter);
        aux.setDisplayFormatter(formatter);
        aux.setEditFormatter(formatter);
        aux.setNullFormatter(formatter);
        return aux;
    }

    public static DefaultFormatterFactory getShortFormatterDigits(int integerDigits) {
        DefaultFormatterFactory aux = new DefaultFormatterFactory();
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setMaximumFractionDigits(0);
        format.setMinimumFractionDigits(0);
        format.setMaximumIntegerDigits(integerDigits);
        format.setMinimumIntegerDigits(0);
        format.setParseIntegerOnly(true);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Short.class);
        aux.setDefaultFormatter(formatter);
        aux.setDisplayFormatter(formatter);
        aux.setEditFormatter(formatter);
        aux.setNullFormatter(formatter);
        return aux;
    }

    public static DefaultFormatterFactory getFixedIntegerMask(int size) {
        if (fixedIntegerMask == null) {
            fixedIntegerMask = new DefaultFormatterFactory();
            StringBuffer strMask = new StringBuffer();
            for (int i = 1; i <= size; ++i) {
                strMask.append("#");
            }
            try {
                MaskFormatter mask = new MaskFormatter(strMask.toString());
                mask.setPlaceholderCharacter('_');
                mask.setValueContainsLiteralCharacters(false);
                fixedIntegerMask.setDefaultFormatter(mask);
                fixedIntegerMask.setEditFormatter(mask);
                fixedIntegerMask.setDisplayFormatter(mask);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return fixedIntegerMask;
    }

    public static DefaultFormatterFactory getCPFMask() {
        if (cpfMask == null) {
            try {
                MaskFormatter mask = new MaskFormatter("###.###.###-##");
                mask.setValueContainsLiteralCharacters(false);
                cpfMask = new DefaultFormatterFactory(mask, mask, mask);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return cpfMask;
    }

    public static DefaultFormatterFactory getCNPJMask() {
        if (cnpjMask == null) {
            try {
                MaskFormatter mask = new MaskFormatter("##.###.###/####-##");
                mask.setValueContainsLiteralCharacters(false);
                cnpjMask = new DefaultFormatterFactory(mask, mask, mask);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return cnpjMask;
    }

    public static DefaultFormatterFactory getCEPMask() {
        if (cepMask == null) {
            try {
                MaskFormatter mask = new MaskFormatter("#####-###");
                mask.setValueContainsLiteralCharacters(true);
                cepMask = new DefaultFormatterFactory(mask, mask, mask);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return cepMask;
    }

    public static DefaultFormatterFactory getDefaultLongFormatter() {
        if (longFormatterFactory == null) {
            longFormatterFactory = new DefaultFormatterFactory();
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(0);
            format.setMinimumFractionDigits(0);
            format.setMaximumIntegerDigits(16);
            format.setMinimumIntegerDigits(0);
            format.setParseIntegerOnly(true);
            NumberFormatter formatter = new NumberFormatter(format);
            formatter.setValueClass(Long.class);
            longFormatterFactory.setDefaultFormatter(formatter);
            longFormatterFactory.setDisplayFormatter(formatter);
            longFormatterFactory.setEditFormatter(formatter);
        }
        return longFormatterFactory;
    }
}

