/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.util.ContatoDateUtil;
import contatocore.util.UtilAbstractObjectBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class UtilObservacoes {
    public static String fillTokens(String toFill, Object data) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, InvocationTargetException {
        for (String token : UtilObservacoes.extractTokens(toFill)) {
            Object value = null;
            for (String path : UtilObservacoes.extractFullPath(token)) {
                if (value != null && value instanceof List || data != null && data instanceof List) {
                    StringBuilder values = null;
                    for (Object o : (List)value) {
                        if (values == null) {
                            values = new StringBuilder();
                            values.append(UtilObservacoes.fillTokens(UtilObservacoes.buildRequestToFill(token, path), o));
                            continue;
                        }
                        if (token.contains("|sum|")) {
                            Double doubleValue = Double.parseDouble(values.toString()) + Double.parseDouble(UtilObservacoes.fillTokens(UtilObservacoes.buildRequestToFill(token, path), o));
                            values = new StringBuilder(Double.toString(doubleValue));
                            continue;
                        }
                        values.append(", ").append(UtilObservacoes.fillTokens(UtilObservacoes.buildRequestToFill(token, path), o));
                    }
                    toFill = toFill.replace(token, values);
                    return toFill;
                }
                if (value != null) {
                    value = UtilObservacoes.extractValue(path, value);
                    continue;
                }
                value = UtilObservacoes.extractValue(path, data);
            }
            toFill = toFill.replace(token, UtilObservacoes.valueToString(value));
        }
        return toFill;
    }

    public static DefaultMutableTreeNode buildObservacaoTree(Class classe) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(classe.getSimpleName());
        List<Field> fields = UtilObservacoes.extractFields(classe.getDeclaredFields(), classe);
        for (Field field : fields) {
            DefaultMutableTreeNode toAdd = new DefaultMutableTreeNode(field.getName()){
                private Class userClass;

                @Override
                public void setUserObject(Object userObject) {
                    this.userClass = (Class)userObject;
                }

                @Override
                public Object getUserObject() {
                    return this.userClass;
                }
            };
            Class c = UtilObservacoes.getFieldType(field, classe);
            toAdd.setUserObject(c);
            node.add(toAdd);
        }
        return node;
    }

    private static Boolean isFather(Field father, Class child) {
        for (Field field : father.getType().getDeclaredFields()) {
            Class fieldType = UtilObservacoes.getFieldType(field, father.getType());
            if (fieldType == null || !fieldType.equals(child)) continue;
            return true;
        }
        return false;
    }

    private static List<Field> extractFields(Field[] fields, Class classe) {
        ArrayList<Field> ret = new ArrayList<Field>();
        for (Field field : fields) {
            if (!UtilObservacoes.isFieldDeclared(field, classe).booleanValue()) continue;
            ret.add(field);
        }
        return ret;
    }

    private static Boolean isFieldDeclared(Field field, Class classe) {
        try {
            String methodName = UtilObservacoes.extractMethodName("get", field.getName());
            Method method = UtilAbstractObjectBuilder.searchMethod(methodName, classe);
            if (method == null) {
                return false;
            }
            if (method.getAnnotation(Transient.class) != null) {
                return false;
            }
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static Class getFieldType(Field f, Class classe) {
        try {
            String methodName = UtilObservacoes.extractMethodName("get", f.getName());
            Method method = UtilAbstractObjectBuilder.searchMethod(methodName, classe);
            if (method != null) {
                return UtilObservacoes.getRetornos(method);
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private static String extractMethodName(String getSet, String fieldName) {
        return getSet + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static Class getRetornos(Method m) {
        Class cl = UtilObservacoes.getAnnotationOneToOne(m);
        if (cl != null) {
            return cl;
        }
        cl = UtilObservacoes.getAnnotationManyToOne(m);
        if (cl != null) {
            return cl;
        }
        cl = UtilObservacoes.getAnnotationOneToMany(m);
        if (cl != null) {
            return cl;
        }
        return m.getReturnType();
    }

    private static Class getAnnotationOneToOne(Method m) {
        OneToOne o = m.getAnnotation(OneToOne.class);
        if (o != null) {
            Class c = o.targetEntity();
            if (c.getClassLoader() != null) {
                return c;
            }
            return m.getReturnType();
        }
        return null;
    }

    private static Class getAnnotationManyToOne(Method m) {
        ManyToOne o = m.getAnnotation(ManyToOne.class);
        if (o != null) {
            Class c = o.targetEntity();
            if (c.getClassLoader() != null) {
                return c;
            }
            return m.getReturnType();
        }
        return null;
    }

    private static Class getAnnotationOneToMany(Method m) {
        OneToMany o = m.getAnnotation(OneToMany.class);
        if (o != null && m.getGenericReturnType() instanceof ParameterizedTypeImpl) {
            Class<?> c = o.targetEntity().getClass();
            if (c.getClassLoader() != null) {
                return c;
            }
            ParameterizedTypeImpl p = (ParameterizedTypeImpl)m.getGenericReturnType();
            if (p.getActualTypeArguments() != null && p.getActualTypeArguments()[0] != null) {
                Class cc = (Class)p.getActualTypeArguments()[0];
                return cc;
            }
        }
        return null;
    }

    private static String buildRequestToFill(String fullPath, String startPath) {
        String ret = "@";
        for (String str : UtilObservacoes.extractFullPath(fullPath, startPath)) {
            ret = ret + str + ".";
        }
        ret = ret + "@";
        return ret;
    }

    private static List<String> extractTokens(String toFill) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern pattern = Pattern.compile("@(.*?)@");
        Matcher matcher = pattern.matcher(toFill);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                tokens.add(matcher.group(i));
            }
        }
        return tokens;
    }

    private static List<String> extractFullPath(String token) {
        ArrayList<String> path = new ArrayList<String>();
        token = token.replace("@", "").replace("|sum|", "");
        path.addAll(Arrays.asList(token.split("\\.")));
        return path;
    }

    private static List<String> extractFullPath(String token, String startWith) {
        ArrayList<String> path = new ArrayList<String>();
        ArrayList<String> ret = new ArrayList<String>();
        Boolean start = false;
        token = token.replace("@", "");
        path.addAll(Arrays.asList(token.split("\\.")));
        for (String str : path) {
            if (str.equals(startWith)) {
                start = true;
            }
            if (!start.booleanValue()) continue;
            ret.add(str);
        }
        return ret;
    }

    private static Object extractValue(String path, Object source) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, InvocationTargetException {
        String methodName = "get" + path.substring(0, 1).toUpperCase() + path.substring(1);
        Method method = UtilAbstractObjectBuilder.searchMethod(methodName, source.getClass());
        if (source == null || method == null) {
            return null;
        }
        return method.invoke(source, new Object[0]);
    }

    private static String valueToString(Object toConvert) {
        if (toConvert == null) {
            return "";
        }
        Class<?> type = toConvert.getClass();
        if (type.equals(Long.class)) {
            return Long.toString((Long)toConvert);
        }
        if (type.equals(Double.class)) {
            return Double.toString((Double)toConvert);
        }
        if (type.equals(Date.class)) {
            return ContatoDateUtil.dateToStr((Date)toConvert, "dd/MM/yyyy");
        }
        if (type.equals(Timestamp.class)) {
            return ContatoDateUtil.dateToStr((Date)((Timestamp)toConvert), "dd/MM/yyyy-HH:mm:ss");
        }
        if (type.equals(Short.class)) {
            return Short.toString((Short)toConvert);
        }
        if (type.equals(Integer.class)) {
            return Integer.toString((Integer)toConvert);
        }
        if (type.equals(String.class)) {
            return (String)toConvert;
        }
        return "";
    }
}

