/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.util.UtilSerializaObjetos;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class UtilSecurityTools {
    private static Logger logger = Logger.getLogger(UtilSecurityTools.class);

    public static String generateMD5(Object message) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        BigInteger hash = new BigInteger(1, md.digest(UtilSerializaObjetos.serialize(message)));
        return hash.toString(16);
    }

    public static String generateMD5(byte[] message) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        BigInteger hash = new BigInteger(1, md.digest(message));
        return hash.toString(16);
    }

    public static Short checkMD5(HashMap data) {
        String checkSUMCalculated;
        Short status = 0;
        String checkSUMParameter = (String)data.get("checksum");
        try {
            checkSUMCalculated = UtilSecurityTools.generateMD5(data.get("data"));
        }
        catch (IOException ex) {
            return (short)0;
        }
        if (checkSUMCalculated.equals(checkSUMParameter)) {
            status = 1;
        }
        return status;
    }

    public static String encodeData(String data) {
        byte[] enc;
        try {
            enc = UtilSecurityTools.encode(UtilSecurityTools.nullPadString(data).getBytes(), UtilSecurityTools.GenerateKey());
        }
        catch (Exception ex) {
            return null;
        }
        return UtilSecurityTools.fromHex(enc);
    }

    public static String decodeData(String data) {
        byte[] msg;
        byte[] msgEnc = UtilSecurityTools.toHex(data);
        try {
            msg = UtilSecurityTools.decode(msgEnc, UtilSecurityTools.GenerateKey());
        }
        catch (Exception ex) {
            return null;
        }
        return new String(msg).trim();
    }

    public static String generateMD5FromFile(String arquivo) throws FileNotFoundException, IOException {
        File fileOrigin = new File(arquivo);
        if (!fileOrigin.exists()) {
            return "";
        }
        FileInputStream i = new FileInputStream(fileOrigin);
        BufferedInputStream in = new BufferedInputStream(i);
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        byte[] bt = new byte[1];
        while (in.read(bt) != -1) {
            bytes.add(bt);
            bt = new byte[1];
        }
        in.close();
        bt = new byte[bytes.size()];
        for (int j = 0; j < bytes.size(); ++j) {
            bt[j] = ((byte[])bytes.get(j))[0];
        }
        return UtilSecurityTools.generateMD5(bt);
    }

    private static byte[] GenerateKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(200L);
        keyGen.init(128, secureRandom);
        SecretKey generatedKey = keyGen.generateKey();
        return generatedKey.getEncoded();
    }

    private static byte[] encode(byte[] input, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException {
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(input);
        return encrypted;
    }

    private static byte[] decode(byte[] input, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException {
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, skeySpec);
        byte[] decrypted = cipher.doFinal(input);
        return decrypted;
    }

    private static String nullPadString(String original) {
        StringBuilder output = new StringBuilder(original);
        int remain = output.length() % 16;
        if (remain != 0) {
            remain = 16 - remain;
            for (int i = 0; i < remain; ++i) {
                output.append('\u0000');
            }
        }
        return output.toString();
    }

    private static String fromHex(byte[] hex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hex.length; ++i) {
            sb.append(Integer.toString((hex[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private static byte[] toHex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

