/*
 * Decompiled with CFR 0.152.
 */
package executarmentor;

import executarmentor.Main;
import executarmentor.ZipUtils;
import executarmentor.banco.ConectToDatabase;
import executarmentor.gui.DialogsHelperFrame;
import executarmentor.model.VOQuerySQL;
import executarmentor.properties.LocalProperties;
import executarmentor.util.UtilBackupDatabase;
import executarmentor.util.UtilFile;
import executarmentor.util.UtilReadQueriesFromFile;
import executarmentor.wait.WaitFrame;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class AtualizarArquivoLocal {
    private WaitFrame waitFrame;

    public void atualizarArquivoLocal(Integer codigoAplicacao) throws Exception {
        this.executeUpdateInternal(codigoAplicacao);
        UtilFile.deleteFile(UtilFile.getTempDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateInternal(Integer codigoAplicacao) {
        this.showStatusDialog();
        try {
            List<HashMap> local = LocalProperties.getInstance().getVersoesLocaisToUpdate();
            int nrVersions = local.size();
            int current = 1;
            for (HashMap h : local) {
                String arquivo = (String)h.get("arquivo");
                Integer codigoVersao = Integer.valueOf((String)h.get("codigo"));
                String descricao = (String)h.get("descricao");
                int perc = current / nrVersions;
                this.setStatusText("Atualizando vers\u00e3o " + codigoVersao + "(" + current + "/" + nrVersions + ")");
                this.extractAndCheckFiles(arquivo, perc, descricao);
                LocalProperties.getInstance().setCodigoVersao(codigoVersao);
                ++current;
            }
            LocalProperties.getInstance().clearVersions(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DialogsHelperFrame.showError("Erro ao atualizar o sistema.\n" + ex.getMessage());
        }
        finally {
            this.closeStatusDialog();
        }
    }

    private void deletePathFiles(File f) {
        if (f.exists()) {
            f.delete();
            if (f.isDirectory()) {
                for (File faux : f.listFiles()) {
                    this.deletePathFiles(faux);
                }
            }
        }
    }

    private void updateLocalAPP(File path) throws IOException {
        if (path.exists()) {
            System.out.println("Atualizando para patch: " + path.getName());
            new ZipUtils().extrairZip(path, new File(System.getProperty("user.dir")));
        }
        this.deletePathFiles(path);
    }

    private void extractAndCheckFiles(String file, Integer codigo, String descricao) throws Exception {
        File cached = new File(file);
        File[] files = this.unzipAndGetFiles(cached, null);
        File props = this.getFileFromDir(files, "update.properties");
        if (props == null) {
            throw new Exception("Arquivo de atualiza\u00e7\u00e3o da vers\u00e3o " + codigo + " inv\u00e1lido " + descricao + ". N\u00e3o contem arquivo de propriedades.");
        }
        Properties pr = new Properties();
        pr.load(new FileInputStream(props));
        String arquivoServidor = pr.getProperty("arquivo_servidor");
        String arquivoAplicacao = pr.getProperty("arquivo_aplicacao");
        String urlModificacoes = pr.getProperty("urlModificacoes");
        if (arquivoAplicacao != null && arquivoAplicacao.trim().length() > 0) {
            File app = this.getFileFromDir(files, arquivoAplicacao);
            this.updateLocalAPP(app);
        }
        if (arquivoServidor != null && arquivoServidor.trim().length() > 0) {
            File server = this.getFileFromDir(files, arquivoServidor);
            this.updateFileServer(server, codigo, descricao);
        }
    }

    File[] unzipAndGetFiles(File file, final String extension) throws IOException {
        ZipUtils z = new ZipUtils();
        new UtilFile();
        File tmpDir = UtilFile.getTempDir();
        tmpDir.mkdirs();
        z.extrairZip(file, new File(tmpDir.getAbsolutePath()));
        File[] files = tmpDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (extension == null) {
                    return true;
                }
                return pathname.getName().toUpperCase().endsWith(extension.toUpperCase());
            }
        });
        return files;
    }

    private File getFileFromDir(File[] files, String updateproperties) throws Exception {
        if (updateproperties == null || updateproperties.trim().length() == 0) {
            return null;
        }
        File found = null;
        for (File f : files) {
            if (!f.getName().toUpperCase().equals(updateproperties.toUpperCase())) continue;
            return f;
        }
        if (found == null) {
            throw new Exception(" Arquivo definido nas propriedades da atualiza\u00e7\u00e3o n\u00e3o encontrado no pacote. Contate suporte. " + updateproperties);
        }
        return found;
    }

    private void updateFileServer(File server, Integer codigoVersao, String descricao) throws Exception {
        Integer codigoAtualVersao = ConectToDatabase.getVersaoAtualBD();
        if (codigoAtualVersao == null || codigoAtualVersao < codigoVersao) {
            File[] files = this.unzipAndGetFiles(server, "upd");
            new UtilBackupDatabase().copiarBancoDeDados(ConectToDatabase.getPathFromBD());
            List<VOQuerySQL> queries = new UtilReadQueriesFromFile().getQueriesSQL(files);
            ConectToDatabase.runManyQueries(queries);
            ConectToDatabase.insertVersion(codigoVersao, descricao);
            new UtilFile();
            UtilFile.deleteFiles(files);
        }
    }

    private void showStatusDialog() {
        if (Main.graphical) {
            this.waitFrame = new WaitFrame();
            this.waitFrame.setLocationRelativeTo(null);
            this.waitFrame.setVisible(true);
        }
    }

    private void closeStatusDialog() {
        if (this.waitFrame != null) {
            this.waitFrame.dispose();
        }
    }

    private void setStatusText(String string) {
        if (this.waitFrame != null) {
            this.waitFrame.updateText(string);
        }
    }
}

