/*
 * Decompiled with CFR 0.152.
 */
package executarmentor;

import executarmentor.Main;
import executarmentor.ZipUtils;
import executarmentor.banco.ConectToDatabase;
import executarmentor.banco.URLDatabaseUtil;
import executarmentor.gui.DialogsHelperFrame;
import executarmentor.properties.LocalProperties;
import executarmentor.wait.WaitFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class AtualizarVersaoRemota {
    private WaitFrame waitFrame;

    public void verificarEAtualizar(Integer codigoAplicacao) {
        this.updateInternal(codigoAplicacao);
    }

    private void updateMentor(Integer versaoToUp, Integer codigoSistema) {
        try {
            Connection con = ConectToDatabase.openConectionBD(URLDatabaseUtil.getURLVersoes());
            PreparedStatement p = con.prepareStatement("select ARQUIVO_CLIENTE v from versoes v where v.codigo=? and v.codigo_sistema=?");
            p.setInt(1, versaoToUp);
            p.setInt(2, codigoSistema);
            ResultSet r = p.executeQuery();
            byte[] blob = null;
            while (r.next()) {
                Blob b = r.getBlob(1);
                blob = b.getBytes(1L, (int)b.length());
            }
            if (blob != null && blob.length > 0) {
                File temp = File.createTempFile("mentorupdate", ".zip");
                FileOutputStream fos = new FileOutputStream(temp);
                fos.write(blob);
                fos.flush();
                fos.close();
                new ZipUtils().extrairZip(temp, new File(System.getProperty("user.dir")));
                LocalProperties.getInstance().setCodigoVersao(versaoToUp);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            DialogsHelperFrame.showError("Erro ao atualizar seu sistema.\n*Erro ao ler o arquivo da vers\u00e3o.\n*O mentor ou outro arquivo utilizado pelo mentor est\u00e1 aberto.");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            DialogsHelperFrame.showError("Erro ao verificar a vers\u00e3o.");
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            DialogsHelperFrame.showError("Erro ao verificar a vers\u00e3o e/ou conectar ao banco de dados. Tente:\n*Verifique sua rede;\n*Reconfigure o servidor atrav\u00e9s do aplicativo configura\u00e7\u00e3o do servidor.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInternal(Integer codigoAplicacao) {
        this.showStatusDialog();
        try {
            LocalProperties l = LocalProperties.getInstance();
            String versao = l.getCodigoVersao();
            if (versao == null) {
                versao = "0";
            }
            System.out.println("Buscando novas vers\u00f5es para atualiza\u00e7\u00e3o...");
            System.out.println("Versao atual: " + Integer.valueOf(versao) + " Codigo Aplicacao: " + codigoAplicacao);
            System.out.println("Banco Versao Utilizado: " + ConectToDatabase.getPathFromBD());
            List v = ConectToDatabase.getDadosUltimaVersaoBd(Integer.valueOf(versao), codigoAplicacao);
            System.out.println(v.size() + " vers\u00f5es encontradas para atualiza\u00e7\u00e3o.");
            int nrVersoes = v.size();
            int current = 1;
            if (nrVersoes > 0) {
                this.waitFrame.setVisible(true);
            }
            for (Object o : v) {
                HashMap h = (HashMap)o;
                Integer codigoVersao = (Integer)h.get("codigo");
                System.out.println("Atualizando para vers\u00e3o: " + codigoVersao);
                int perc = current / nrVersoes * 100;
                this.setStatusText("Atualizando vers\u00e3o " + codigoVersao + "(" + current + "/" + nrVersoes + ")");
                new AtualizarVersaoRemota().updateMentor(codigoVersao, codigoAplicacao);
                ++current;
                LocalProperties.getInstance().setCodigoVersao(codigoVersao);
            }
            System.out.println("Atualiza\u00e7\u00f5es terminadas.");
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            DialogsHelperFrame.showError("Erro ao verificar a vers\u00e3o. Verifique sua conex\u00e3o e rede, se est\u00e1 conectado a alguma rede e a mesta est\u00e1 funcionando.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DialogsHelperFrame.showError("Erro ao verificar a vers\u00e3o. Driver de conex\u00e3o com o banco de dados n\u00e3o encontrado.");
        }
        finally {
            this.closeStatusDialog();
        }
    }

    private void showStatusDialog() {
        if (Main.graphical) {
            this.waitFrame = new WaitFrame();
            this.waitFrame.setLocationRelativeTo(null);
        }
    }

    private void closeStatusDialog() {
        if (this.waitFrame.isVisible()) {
            this.waitFrame.setVisible(false);
        }
        if (this.waitFrame != null) {
            this.waitFrame.dispose();
        }
    }

    private void setStatusText(String string) {
        if (this.waitFrame != null) {
            this.waitFrame.updateText(string);
        }
    }
}

