/*
 * Decompiled with CFR 0.152.
 */
package executarmentor;

import executarmentor.AtualizarArquivoLocal;
import executarmentor.AtualizarPatch;
import executarmentor.AtualizarVersaoRemota;
import executarmentor.gui.DialogsHelperFrame;
import executarmentor.oldversion.AtualizarVersaoRemotaOld;
import executarmentor.properties.LocalProperties;
import java.io.File;
import org.firebirdsql.jdbc.FirebirdDriver;

public class Main {
    public static boolean graphical = true;

    public static void main(String[] args) {
        Object driver = null;
        System.out.println("Starting app. Check for new Versions." + FirebirdDriver.class.getCanonicalName());
        Main.checkParams(args);
        try {
            new AtualizarVersaoRemotaOld().verificarEAtualizar();
            Integer tipoAplicacao = Main.getTipoSistema();
            Integer codigoAplicacao = Main.getCodigoSistema();
            if (tipoAplicacao == 1) {
                new AtualizarVersaoRemota().verificarEAtualizar(codigoAplicacao);
            }
            if (tipoAplicacao == 3 || tipoAplicacao == 4) {
                new AtualizarArquivoLocal().atualizarArquivoLocal(codigoAplicacao);
            }
            new AtualizarPatch().atualizarPatch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "N\u00e3o foi poss\u00edvel atualizar o seu sistema. Contate suporte t\u00e9cnico.";
            DialogsHelperFrame.showError(msg);
        }
        System.exit(0);
    }

    private static Integer getTipoSistema() {
        String tipoAplicacao = LocalProperties.getInstance().getTipoSistema();
        if (tipoAplicacao == null || tipoAplicacao.trim().length() == 0) {
            LocalProperties.getInstance().setTipoAplicacao(1);
            return 1;
        }
        return new Integer(tipoAplicacao);
    }

    private static Integer getCodigoSistema() {
        String codigoAplicacao = LocalProperties.getInstance().getCodigoSistema();
        if (codigoAplicacao == null || codigoAplicacao.trim().length() == 0) {
            LocalProperties.getInstance().setCodigoAplicacao(7);
            return 7;
        }
        return new Integer(codigoAplicacao);
    }

    private static void checkParams(String[] args) {
        if (args.length % 2 != 0) {
            System.out.println("numero parametros invalidos: -g (sim/nao) = Exibir modo grafico, -l (local de execucao)");
            return;
        }
        int i = 0;
        while (i < args.length) {
            String paramType;
            switch (paramType = args[i]) {
                case "-g": {
                    Main.setGraphical(args[i + 1]);
                    break;
                }
                case "-l": {
                    Main.setLocation(args[i + 1]);
                }
            }
            i = 2;
        }
    }

    private static void setGraphical(String arg) {
        graphical = !arg.equalsIgnoreCase("nao");
    }

    private static void setLocation(String arg) {
        File f = new File(arg);
        if (!f.exists()) {
            return;
        }
        System.setProperty("user.dir", f.getAbsolutePath());
    }
}

