/*
 * Decompiled with CFR 0.152.
 */
package executarmentor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private File arquivoZipAtual;
    private static final int TAMANHO_BUFFER = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listarEntradasZip(File arquivo) throws ZipException, IOException {
        ArrayList<ZipEntry> entradasDoZip = new ArrayList<ZipEntry>();
        try (ZipFile zip = null;){
            zip = new ZipFile(arquivo);
            Enumeration<? extends ZipEntry> e = zip.entries();
            ZipEntry entrada = null;
            while (e.hasMoreElements()) {
                entrada = e.nextElement();
                entradasDoZip.add(entrada);
            }
            this.setArquivoZipAtual(arquivo);
        }
        return entradasDoZip;
    }

    public void extrairZip(File diretorio) throws ZipException, IOException {
        this.extrairZip(this.getArquivoZipAtual(), diretorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extrairZip(File arquivoZip, File diretorio) throws ZipException, IOException {
        ZipFile zip = null;
        File arquivo = null;
        InputStream is = null;
        OutputStream os = null;
        byte[] buffer = new byte[2048];
        try {
            if (!diretorio.exists()) {
                diretorio.mkdirs();
            }
            if (!diretorio.exists() || !diretorio.isDirectory()) {
                throw new IOException("Informe um diret\ufffdrio v\ufffdlido");
            }
            zip = new ZipFile(arquivoZip);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entrada = e.nextElement();
                arquivo = new File(diretorio, entrada.getName());
                if (entrada.isDirectory() && !arquivo.exists()) {
                    arquivo.mkdirs();
                    continue;
                }
                if (!arquivo.getParentFile().exists()) {
                    arquivo.getParentFile().mkdirs();
                }
                try {
                    is = zip.getInputStream(entrada);
                    if (entrada.isDirectory()) continue;
                    os = new FileOutputStream(arquivo);
                    int bytesLidos = 0;
                    if (is == null) {
                        throw new ZipException("Erro ao ler a entrada do zip: " + entrada.getName());
                    }
                    while ((bytesLidos = is.read(buffer)) > 0) {
                        os.write(buffer, 0, bytesLidos);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (os == null) continue;
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List criarZip(File arquivoZip, File[] arquivos) throws ZipException, IOException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        this.setArquivoZipAtual(null);
        try {
            if (!arquivoZip.getName().toLowerCase().endsWith(".zip")) {
                arquivoZip = new File(arquivoZip.getAbsolutePath() + ".zip");
            }
            fos = new FileOutputStream(arquivoZip);
            bos = new BufferedOutputStream(fos, 2048);
            List listaEntradasZip = this.criarZip(bos, arquivos);
            this.setArquivoZipAtual(arquivoZip);
            List list = listaEntradasZip;
            return list;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List criarZip(OutputStream os, File[] arquivos) throws ZipException, IOException {
        if (arquivos == null || arquivos.length < 1) {
            throw new ZipException("Adicione ao menos um arquivo ou diret\ufffdrio");
        }
        ArrayList listaEntradasZip = new ArrayList();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(os);
            for (int i = 0; i < arquivos.length; ++i) {
                String caminhoInicial = arquivos[i].getParent();
                List novasEntradas = this.adicionarArquivoNoZip(zos, arquivos[i], caminhoInicial);
                if (novasEntradas == null) continue;
                listaEntradasZip.addAll(novasEntradas);
            }
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
            }
        }
        return listaEntradasZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List adicionarArquivoNoZip(ZipOutputStream zos, File arquivo, String caminhoInicial) throws IOException {
        ArrayList<ZipEntry> listaEntradasZip = new ArrayList<ZipEntry>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        byte[] buffer = new byte[2048];
        try {
            if (arquivo.isDirectory()) {
                File[] arquivos = arquivo.listFiles();
                for (int i = 0; i < arquivos.length; ++i) {
                    List novasEntradas = this.adicionarArquivoNoZip(zos, arquivos[i], caminhoInicial);
                    if (novasEntradas == null) continue;
                    listaEntradasZip.addAll(novasEntradas);
                }
                ArrayList<ZipEntry> i = listaEntradasZip;
                return i;
            }
            String caminhoEntradaZip = null;
            int idx = arquivo.getAbsolutePath().indexOf(caminhoInicial);
            if (idx >= 0) {
                caminhoEntradaZip = arquivo.getAbsolutePath().substring(idx + caminhoInicial.length() + 1);
            }
            ZipEntry entrada = new ZipEntry(caminhoEntradaZip);
            zos.putNextEntry(entrada);
            zos.setMethod(8);
            fis = new FileInputStream(arquivo);
            bis = new BufferedInputStream(fis, 2048);
            int bytesLidos = 0;
            while ((bytesLidos = bis.read(buffer, 0, 2048)) != -1) {
                zos.write(buffer, 0, bytesLidos);
            }
            listaEntradasZip.add(entrada);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception novasEntradas) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception novasEntradas) {}
            }
        }
        return listaEntradasZip;
    }

    public void fecharZip() {
        this.setArquivoZipAtual(null);
    }

    public File getArquivoZipAtual() {
        return this.arquivoZipAtual;
    }

    private void setArquivoZipAtual(File arquivoZipAtual) {
        this.arquivoZipAtual = arquivoZipAtual;
    }
}

