/*
 * Decompiled with CFR 0.152.
 */
package executarmentor.banco;

import executarmentor.banco.URLDatabaseUtil;
import executarmentor.model.VOQuerySQL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.firebirdsql.jdbc.FBDriver;

public class ConectToDatabase {
    public static Connection openConectionBD() throws ClassNotFoundException, SQLException {
        System.out.println("checking if class is available");
        Class<FBDriver> temp = FBDriver.class;
        String ur = URLDatabaseUtil.getURLVersoes();
        Connection con = DriverManager.getConnection(ur, "SYSDBA", "masterkey");
        con.setAutoCommit(false);
        return con;
    }

    public static Connection openConectionBD(String ur) throws ClassNotFoundException, SQLException {
        System.out.println("checking if class is available");
        Class<FBDriver> temp = FBDriver.class;
        Connection con = DriverManager.getConnection(ur, "SYSDBA", "masterkey");
        con.setAutoCommit(false);
        return con;
    }

    public static List getDadosUltimaVersaoBd(Integer versao, Integer codigoAplicacao) throws SQLException, ClassNotFoundException {
        ArrayList v;
        try (Connection con = ConectToDatabase.openConectionBD();){
            String statement = "select CODIGO,descricao,data_atualizacao from versoes v where (v.codigo>? ) and v.codigo_sistema = ? order by v.codigo";
            PreparedStatement p = con.prepareStatement(statement);
            p.setInt(1, versao);
            p.setInt(2, codigoAplicacao);
            ResultSet r = p.executeQuery();
            v = new ArrayList();
            while (r.next()) {
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("descricao", r.getString("DESCRICAO"));
                h.put("codigo", r.getInt("CODIGO"));
                h.put("data.atualizacao", r.getDate("DATA_ATUALIZACAO"));
                v.add(h);
            }
            con.commit();
        }
        return v;
    }

    public static String getPathFromBD() throws Exception {
        try {
            Connection conn = ConectToDatabase.openConectionBD();
            String codigo = null;
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("SELECT MON$DATABASE_NAME FROM MON$DATABASE");
            if (rs.next()) {
                codigo = rs.getString(1);
            }
            return codigo;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new Exception("N\u00e3o foi poss\u00edvel conectar ao Banco de Dados.\n" + ex.getMessage());
        }
    }

    public static void runManyQueries(List<VOQuerySQL> queries) throws Exception {
        try {
            Connection conn = ConectToDatabase.openConectionBD();
            for (VOQuerySQL q : queries) {
                try {
                    PreparedStatement prep = conn.prepareStatement(q.getQuery());
                    prep.execute();
                }
                catch (Exception ex) {
                    conn.rollback();
                    ex.printStackTrace();
                    q.setQueryErrorMessage(ex.getMessage());
                    q.setStatus((short)0);
                }
                conn.commit();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new Exception("N\u00e3o foi poss\u00edvel conectar ao Banco de Dados.\n" + ex.getMessage());
        }
    }

    public static void insertVersion(Integer codigoVersao, String descricao) throws Exception {
        try {
            Connection conn = ConectToDatabase.openConectionBD();
            PreparedStatement prep = conn.prepareStatement("update or INSERT INTO VERSAO (CODIGO, DESCRICAO) VALUES (?, ?) matching (codigo)");
            prep.setInt(1, codigoVersao);
            prep.setString(2, descricao);
            conn.commit();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new Exception("N\u00e3o foi poss\u00edvel conectar ao Banco de Dados.\n" + ex.getMessage());
        }
    }

    public static Integer getVersaoAtualBD() throws Exception {
        try {
            Connection conn = ConectToDatabase.openConectionBD();
            PreparedStatement prep = conn.prepareStatement("select max(codigo) from VERSAO ");
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
            conn.commit();
            return 0;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new Exception("N\u00e3o foi poss\u00edvel conectar ao Banco de Dados.\n" + ex.getMessage());
        }
    }
}

