/*
 * Decompiled with CFR 0.152.
 */
package executarmentor.oldversion;

import executarmentor.ZipUtils;
import executarmentor.banco.ConectToDatabase;
import executarmentor.banco.URLDatabaseUtil;
import executarmentor.properties.LocalProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JOptionPane;

public class ExecutarMentor {
    public void updateMentor(Integer versaoToUp, Integer versaoBancoBeta) {
        try {
            Connection con = ConectToDatabase.openConectionBD(URLDatabaseUtil.getURLVersoes());
            PreparedStatement p = con.prepareStatement("select ARQUIVO_CLIENTE v from versoes v where v.codigo=? and v.sub_codigo=?");
            p.setInt(1, versaoToUp);
            p.setInt(2, versaoBancoBeta);
            ResultSet r = p.executeQuery();
            byte[] blob = null;
            while (r.next()) {
                Blob b = r.getBlob(1);
                blob = b.getBytes(1L, (int)b.length());
            }
            if (blob != null && blob.length > 0) {
                File temp = File.createTempFile("mentorupdate", ".zip");
                FileOutputStream fos = new FileOutputStream(temp);
                fos.write(blob);
                fos.flush();
                fos.close();
                new ZipUtils().extrairZip(temp, new File(System.getProperty("user.dir")));
                LocalProperties.getInstance().setCodigoVersao(versaoToUp);
                LocalProperties.getInstance().setSubCodigoVersao(versaoBancoBeta);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erro ao atualizar seu sistema.\n*Erro ao ler o arquivo da vers\u00e3o.\n*O mentor ou outro arquivo utilizado pelo mentor est\u00e1 aberto.");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erro ao verificar a vers\u00e3o.");
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erro ao verificar a vers\u00e3o e/ou conectar ao banco de dados. Tente:\n*Verifique sua rede;\n*Reconfigure o servidor atrav\u00e9s do aplicativo configura\u00e7\u00e3o do servidor.");
        }
    }

    public void executar(String classe, String metodo) {
        try {
            Class<?> ob = Class.forName(classe);
            String[] st = new String[]{};
            Method m = ob.getDeclaredMethod(metodo, String[].class);
            m.invoke(ob, new Object[]{st});
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erro ao executar o aplicativo!");
        }
    }
}

