/*
 * Decompiled with CFR 0.152.
 */
package executarmentor.properties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class LocalProperties {
    private final String VERSAO_CODIGO = "versao.codigo";
    private final String SUB_CODIGO_VERSAO = "versao.sub.codigo";
    private final String HOST = "host";
    private final String HOST_COMMUNICATOR = "url.host.communicador";
    private final String PORT = "porta";
    private final String URL_DATABASE = "url.database";
    private final String TIPO_SISTEMA = "tipo.sistema";
    private final String URL_DATABASE_ENDERECOS = "url.database.cep";
    private final String URL_DATABASE_NFE = "url.database.nfe";
    private final String URL_DATABASE_COMMUNICATOR = "url.database.communicator";
    private final String URL_DATABASE_LOG = "url.database.log";
    private final String URL_DATABASE_VERSAO = "url.database.versao";
    private final String path = System.getProperty("user.dir") + "/local.xml";
    private final String GENERATION_STRATEGY = "generationStrategy";
    private final String EXIBIR_SQL = "exibirSql";
    private final String XML_PATCH_UPDATE = "xml.patch.update";
    private final String CODIGO_SISTEMA = "codigo.sistema";

    private LocalProperties() {
    }

    public static LocalProperties getInstance() {
        return new LocalProperties();
    }

    public String getTableGenerationStrategy() {
        return this.returnProperties("generationStrategy");
    }

    private void addProperties(String key, String value) {
        Element root = this.getRootElement();
        Element e = root.getChild(key);
        if (e == null) {
            e = new Element(key);
            root.addContent(e);
        }
        e.setText(value);
        this.gravarArquivo(root);
    }

    private String returnProperties(String name) {
        Element root = this.getRootElement();
        Element child = root.getChild(name);
        String value = null;
        if (child != null) {
            value = child.getText();
        }
        return value;
    }

    public void clearVersions(String absolutePath) {
        Element root = this.getRootElement();
        Element child = root.getChild("versoes");
        if (child != null) {
            child.getChildren().clear();
        }
        this.gravarArquivo(root);
    }

    public List<HashMap> getVersoesLocaisToUpdate() {
        Element root = this.getRootElement();
        Element child = root.getChild("versoes");
        LinkedList<HashMap> ret = new LinkedList<HashMap>();
        if (child == null) {
            return ret;
        }
        for (Element e : child.getChildren()) {
            String codigo = e.getAttributeValue("codigo");
            String descricao = e.getAttributeValue("descricao");
            String arquivo = e.getAttributeValue("arquivo");
            HashMap<String, String> h = new HashMap<String, String>();
            h.put("codigo", codigo);
            h.put("descricao", descricao);
            h.put("arquivo", arquivo);
            ret.add(h);
        }
        return ret;
    }

    private Element getRootElement() {
        Element r = new Element("mentorLocal");
        try {
            File f = new File(this.path);
            if (f.exists()) {
                SAXBuilder sb = new SAXBuilder();
                Document d = sb.build(f);
                r = d.getRootElement();
            }
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (r == null) {
            r = new Element("mentorLocal");
        }
        return r;
    }

    private void gravarArquivo(Element root) {
        try {
            XMLOutputter xout = new XMLOutputter();
            root = root.detach();
            Document d = new Document(root);
            xout.output(d, (OutputStream)new FileOutputStream(new File(this.path)));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getHostCommunicator() {
        String host = this.returnProperties("url.host.communicador");
        if (host != null) {
            return host;
        }
        return "localhost";
    }

    public String getCodigoVersao() {
        return this.returnProperties("versao.codigo");
    }

    public String getTipoSistema() {
        return this.returnProperties("tipo.sistema");
    }

    public String getCodigoSistema() {
        return this.returnProperties("codigo.sistema");
    }

    public String getCodigoVersaoFormatado() {
        return "MentorERP:" + this.returnProperties("versao.codigo") + "-" + this.returnProperties("versao.sub.codigo");
    }

    public String getSubCodigoVersao() {
        return this.returnProperties("versao.sub.codigo");
    }

    public void setVersaoBeta(String versao) {
        this.addProperties("versao.sub.codigo", versao);
    }

    public void setHost(String string) {
        this.addProperties("host", string);
    }

    public void setCommunicatorIP(String string) {
        this.addProperties("url.host.communicador", string);
    }

    public void setPort(String str) {
        this.addProperties("porta", str);
    }

    public void setURLMentor(String str) {
        this.addProperties("url.database", str);
    }

    public void setURLEndereco(String str) {
        this.addProperties("url.database.cep", str);
    }

    public void setURLNfe(String str) {
        this.addProperties("url.database.nfe", str);
    }

    public void setURLCommunicator(String str) {
        this.addProperties("url.database.communicator", str);
    }

    public String getURLNfe() {
        return this.returnProperties("url.database.nfe");
    }

    public String getURLCommunicator() {
        return this.returnProperties("url.database.communicator");
    }

    public String getHost() {
        return this.returnProperties("host");
    }

    public String getPort() {
        return this.returnProperties("porta");
    }

    public String getURLMentor() {
        return this.returnProperties("url.database");
    }

    public String getURLEndereco() {
        return this.returnProperties("url.database.cep");
    }

    public String getURLLog() {
        return this.returnProperties("url.database.log");
    }

    public void setURLLog(String str) {
        this.addProperties("url.database.log", str);
    }

    public void setCodigoVersao(Integer versaoToUp) {
        this.addProperties("versao.codigo", versaoToUp.toString());
    }

    public void setSubCodigoVersao(Integer versaoBancoBeta) {
        this.addProperties("versao.sub.codigo", versaoBancoBeta.toString());
    }

    public String getURLVersoes() {
        return this.returnProperties("url.database.versao");
    }

    public void setURLVersao(String str) {
        this.addProperties("url.database.versao", str);
    }

    public String getExibirSQL() {
        return this.returnProperties("exibirSql");
    }

    public void setExibirSQL(String str) {
        this.addProperties("exibirSql", str);
    }

    public String getTipo() {
        return this.returnProperties("tipo.sistema");
    }

    public String getPathToUpdate() {
        return this.returnProperties("xml.patch.update");
    }

    public void setPathToUpdate(String path) {
        this.addProperties("xml.patch.update", path);
    }

    public void setTipoAplicacao(int tipoApp) {
        this.addProperties("tipo.sistema", String.valueOf(tipoApp));
    }

    public void setCodigoAplicacao(int codigoApp) {
        this.addProperties("codigo.sistema", String.valueOf(codigoApp));
    }
}

