/*
 * Decompiled with CFR 0.152.
 */
package executarmentor.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class UtilBackupDatabase {
    private int TAMANHO_BUFFER = 4096;

    public void copiarBancoDeDados(String banco) throws Exception {
        File f = new File(banco);
        if (f.exists()) {
            try {
                String name = f.getName();
                name = name.replace(".", "_");
                String to = f.getParent() + "/backup/" + name;
                Date date = new Date();
                SimpleDateFormat s = new SimpleDateFormat("_dd_MM_yyyy_hh_mm_ss");
                File out = new File(to + s.format(date) + ".zip");
                out.getParentFile().mkdirs();
                this.ziparBD(out, f);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                throw new Exception("Atualiza\u00e7\u00e3o cancelada! Erro ao efetuar backup.");
            }
        } else {
            throw new Exception("Erro ao efetuar backup, Arquivo n\u00e3o encontrado " + f.getAbsolutePath() + ". Fa\u00e7a o backup manualmente e desmarque a op\u00e7\u00e3o \"Gerar backup\" em configura\u00e7\u00f5es.");
        }
    }

    public void ziparBD(File out, File f) throws FileNotFoundException, IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(out));
        ZipEntry entrada = new ZipEntry(f.getName());
        zos.putNextEntry(entrada);
        zos.setMethod(8);
        FileInputStream fis = new FileInputStream(f);
        BufferedInputStream bis = new BufferedInputStream(fis, this.TAMANHO_BUFFER);
        int bytesLidos = 0;
        byte[] buffer = new byte[this.TAMANHO_BUFFER];
        while ((bytesLidos = bis.read(buffer, 0, this.TAMANHO_BUFFER)) != -1) {
            zos.write(buffer, 0, bytesLidos);
        }
        zos.closeEntry();
        zos.flush();
        zos.finish();
        zos.close();
    }
}

