/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSExceptionHelper {
    private static final Logger log = LoggerFactory.getLogger(GDSExceptionHelper.class);
    private static final String MESSAGES = "isc_error_msg";
    private static final String JAYBIRD_MESSAGES = "org/firebirdsql/jaybird_error_msg";
    private static final String SQLSTATES = "isc_error_sqlstates";
    private static final String JAYBIRD_SQLSTATES = "org/firebirdsql/jaybird_error_sqlstates";
    private static final Map<Integer, String> messages;
    private static final Map<Integer, String> sqlstates;

    private static Map<Integer, String> loadResource(boolean deduplicate, String ... resources) throws Exception {
        Properties properties = new Properties();
        IOException firstException = null;
        for (String resource : resources) {
            String resourceFile = "/" + resource.replace('.', '/') + ".properties";
            try (InputStream in = GDSExceptionHelper.getResourceAsStream(resourceFile);){
                if (in != null) {
                    properties.load(in);
                    continue;
                }
                log.warn("Unable to load resource; resource " + resource + " is not found");
            }
            catch (IOException ioex) {
                log.error("Unable to load resource " + resource, ioex);
                if (firstException != null) continue;
                firstException = ioex;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        return GDSExceptionHelper.asErrorCodeMapping(deduplicate, properties);
    }

    private static Map<Integer, String> asErrorCodeMapping(boolean deduplicate, Properties properties) {
        HashMap<String, String> deduplicationMap = deduplicate ? new HashMap<String, String>(128) : Collections.emptyMap();
        HashMap<Integer, String> propsAsMap = new HashMap<Integer, String>(properties.size(), 1.0f);
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            try {
                String keyString = (String)key;
                Integer errorCode = Integer.valueOf(keyString);
                String value = properties.getProperty(keyString);
                if (deduplicate) {
                    if (deduplicationMap.containsKey(value)) {
                        value = (String)deduplicationMap.get(value);
                    } else {
                        deduplicationMap.put(value, value);
                    }
                }
                propsAsMap.put(errorCode, value);
            }
            catch (NumberFormatException e) {
                log.warn("Key " + key + " is not a number; ignored", e);
            }
        }
        return propsAsMap;
    }

    private static InputStream getResourceAsStream(String res) {
        InputStream in = GDSExceptionHelper.class.getResourceAsStream(res);
        if (in == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            in = cl.getResourceAsStream(res);
        }
        return in;
    }

    public static GDSMessage getMessage(int code) {
        String message = messages.get(code);
        return new GDSMessage(message != null ? message : "No message for code " + code + " found.");
    }

    public static String getSQLState(int code) {
        return GDSExceptionHelper.getSQLState(code, "HY000");
    }

    public static String getSQLState(int code, String defaultSQLState) {
        String sqlState = sqlstates.get(code);
        return sqlState != null ? sqlState : defaultSQLState;
    }

    static {
        try {
            messages = GDSExceptionHelper.loadResource(false, MESSAGES, JAYBIRD_MESSAGES);
            sqlstates = GDSExceptionHelper.loadResource(true, SQLSTATES, JAYBIRD_SQLSTATES);
        }
        catch (Exception ex) {
            log.error("Exception in init of GDSExceptionHelper, unable to load error information", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static final class GDSMessage {
        private final String template;
        private final String[] params;
        private final List<String> extraParameters = new ArrayList<String>();

        public GDSMessage(String template) {
            this.template = template;
            this.params = new String[this.getParamCountInternal()];
        }

        public int getParamCount() {
            return this.params.length;
        }

        private int getParamCountInternal() {
            int count = 0;
            for (int i = 0; i < this.template.length(); ++i) {
                if (this.template.charAt(i) != '{') continue;
                ++count;
            }
            return count;
        }

        public void setParameter(int position, String text) {
            if (position < this.params.length) {
                this.params[position] = text;
            }
        }

        public void setParameters(List<String> messageParameters) {
            int position;
            for (position = 0; position < Math.min(this.params.length, messageParameters.size()); ++position) {
                this.params[position] = messageParameters.get(position);
            }
            if (this.params.length < messageParameters.size()) {
                while (position < messageParameters.size()) {
                    this.extraParameters.add(messageParameters.get(position));
                    ++position;
                }
            }
        }

        public String toString() {
            String message = this.template;
            for (int i = 0; i < this.params.length; ++i) {
                String param = "{" + i + "}";
                int pos = message.indexOf(param);
                if (pos <= -1) continue;
                message = message.substring(0, pos) + (this.params[i] != null ? this.params[i] : "(null)") + message.substring(pos + param.length());
            }
            for (String extraParameter : this.extraParameters) {
                message = message + "; " + extraParameter;
            }
            return message;
        }
    }
}

