/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import java.io.PrintStream;
import org.firebirdsql.logging.Logger;

final class ConsoleLogger
implements Logger {
    private static final boolean debugEnabled = false;
    private static final boolean traceEnabled = false;
    private static final boolean infoEnabled = true;
    private static final boolean warnEnabled = true;
    private static final boolean errEnabled = true;
    private static final boolean fatalEnabled = true;
    private String name;

    public ConsoleLogger(String name) {
        int lastPoint = name.lastIndexOf(46);
        this.name = lastPoint == -1 ? name : name.substring(lastPoint + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void out(Object message, Throwable t) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("[" + this.name + "]" + message);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void err(Object message, Throwable t) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.err.println("[" + this.name + "]" + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String message) {
        this.debug(message, null);
    }

    @Override
    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.out(message, t);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }

    @Override
    public void trace(String message) {
        this.trace(message, null);
    }

    @Override
    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.out(message, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String message) {
        this.info(message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.out(message, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String message) {
        this.warn(message, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.err(message, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.err(message, t);
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public void fatal(String message) {
        this.fatal(message, null);
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.err(message, t);
        }
    }
}

