/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.examples.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.model.examples.DefaultEntitiesTest;
import com.touchcomp.basementor.model.examples.vo.EnderecoTest;
import com.touchcomp.basementor.model.examples.vo.GeracaoContaPessoaTest;
import com.touchcomp.basementor.model.examples.vo.UnidadeFederativaTest;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GeracaoContaPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TelefonePessoa;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import java.util.Arrays;
import java.util.List;

public class PessoaTest
extends DefaultEntitiesTest<Pessoa> {
    @Override
    public Pessoa getDefault() {
        Pessoa p = new Pessoa();
        p.setAtivo(this.ativo());
        p.setComplemento(this.getComplemento(p));
        p.setDataAtualizacao(this.dataHoraAtualSQL());
        p.setDataCadastro(this.dataHoraAtual());
        p.setDataInicioRelacionamento(this.dataHoraAtual());
        p.setDistanciaKm(100.0);
        p.setEndereco((Endereco)this.getDefaultTest(EnderecoTest.class));
        p.setEnderecoCobranca(null);
        p.setIdentificador(1L);
        p.setLatitude(1.0);
        p.setLongitude(1.0);
        p.setNome("Denis Ribeiro da Silva");
        p.setNomeFantasia("Deninho");
        p.setObservacao("Teste");
        p.setPessoaContato("Denis");
        p.setTipoPessoa(EnumConstTipoPessoa.PESSOA_PRIMARIA.value);
        p.setUsarComoEnderecoCob(EnumConstantsMentorSimNao.NAO.getValue());
        p.setContasPessoa((GeracaoContaPessoa)this.getDefaultTest(GeracaoContaPessoaTest.class));
        return p;
    }

    public Complemento getComplemento(Pessoa pessoa) {
        Complemento c = new Complemento();
        c.setAtivo(this.ativo());
        c.setCel1("37991944624");
        c.setCel2("37991944624");
        c.setCnae(null);
        c.setCnpj("07612811693");
        c.setCodCei("xxxx");
        c.setCodigoIMA("xxxxx");
        c.setContribuinteEstado(EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId());
        c.setDataAtualizacao(this.dataHoraAtualSQL());
        c.setDataEmissaoRG(this.dataHoraAtual());
        c.setDataEmissaoRic(this.dataHoraAtual());
        c.setDataNascimento(this.toDate("25/06/1986"));
        c.setDataValidadeIMA(this.dataHoraAtual());
        c.setEmailPrincipal("teste@touchcomp.com.br");
        c.setEmails(this.getEmails(c));
        c.setFax1("xxxx");
        c.setFax2("xxxx");
        c.setFone1("3732422427");
        c.setFone2("3732422427");
        c.setHabilitarSuframa(this.sim());
        c.setIdComp(1L);
        c.setInscEst("13442");
        c.setInscrEstadualST(null);
        c.setInscrEstadualST(null);
        c.setInscricaoMunicipal(null);
        c.setNit(0);
        c.setOrgaoEmissor("SSPMG");
        c.setOrgaoEmissorRic(null);
        c.setOutrosTelefones(this.getOutrosTelefones(c));
        c.setPassaporte("xxxx");
        c.setPessoa(pessoa);
        c.setRegistroIdentificacaoCivil(null);
        c.setRg("MG14732972");
        c.setSite("www.touchcomp.com.br");
        c.setSuframa(null);
        c.setTipoPessoa((short)Short.MIN_VALUE);
        c.setUfEmissaoRG((UnidadeFederativa)this.getDefaultTest(UnidadeFederativaTest.class));
        return c;
    }

    private List<TelefonePessoa> getOutrosTelefones(Complemento complemento) {
        TelefonePessoa t = new TelefonePessoa();
        t.setComplemento(complemento);
        t.setDescricao("Fixo");
        t.setIdentificador(1L);
        t.setTelefone("3732422427");
        return Arrays.asList(t);
    }

    private List<EmailPessoa> getEmails(Complemento c) {
        EmailPessoa em = new EmailPessoa();
        em.setAtivo((short)1);
        em.setComplemento(c);
        em.setDescricao("Email Principal");
        em.setEmail("teste@touchcomp.com.br");
        em.setEnviarDadosCotacao(this.sim());
        em.setEnviarDadosCte(this.sim());
        em.setEnviarDadosFinanceiro(this.sim());
        em.setEnviarDadosNfe(this.sim());
        em.setEnviarDadosRelacionamento(this.sim());
        em.setIdentificador(1L);
        return this.toList(em);
    }

    public Pessoa buildIdNome(Long id, String nome) {
        Pessoa obj = new Pessoa();
        obj.setIdentificador(id);
        obj.setNome("Pessoa Test: " + nome);
        return obj;
    }
}

