/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.AfastamentoCaged;
import com.touchcomp.basementor.model.vo.AfastamentoRais;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocMotivoAfastamento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocTipoAcidenteTrabalho;
import com.touchcomp.basementor.model.vo.MediaAfastamentoColaborador;
import com.touchcomp.basementor.model.vo.MovimentoSefip;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="AFASTAMENTO_COLABORADOR")
public class AfastamentoColaborador
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Date dataAfastamento;
    private Date dataRetorno;
    private AfastamentoCaged afastamentoCaged;
    private MovimentoSefip afastamentoSefip;
    private MovimentoSefip retornoSefip;
    private Colaborador colaborador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private AfastamentoRais afastamentoRais;
    private Date dataEstabilidade;
    private Short recolherFgts = 0;
    private Double baseCalculoPagamento = 0.0;
    private Double salarioNominal = 0.0;
    private Double valorMedias = 0.0;
    private List<MediaAfastamentoColaborador> mediaAfastamento = new ArrayList<MediaAfastamentoColaborador>();
    private EsocMotivoAfastamento esocMotivoAfastamento;
    private Short infoMesmoMotivo = 0;
    private EsocTipoAcidenteTrabalho esocTipoAcidente;
    private String codigoCid;
    private Integer qtdadeDiasConcedidos = 0;
    private String orgaoClasse;
    private UnidadeFederativa estadoOrgaoClasse;
    private String medico;
    private Short tipoOrgao = 0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private Date dataInicio;
    private Short informarDataManual = 0;
    private Date dataFinal;
    private String observacao;
    private TipoCalculoEvento eventoLicenca;
    private Short atestadoPorCovid = 0;
    private CentroCusto centroCusto;
    private Short atestadoSeguidoAfastamento = 0;
    private Date periodoInicialMedia;
    private Date periodoFinalMedia;

    @Id
    @Column(nullable=false, unique=true, name="ID_AFASTAMENTO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_AFASTAMENTO_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_AFASTAMENTO_CAGED", foreignKey=@ForeignKey(name="FK_AFASTAMENTO_COLAB_AFAS_CAGED"))
    public AfastamentoCaged getAfastamentoCaged() {
        return this.afastamentoCaged;
    }

    public void setAfastamentoCaged(AfastamentoCaged afastamentoCaged) {
        this.afastamentoCaged = afastamentoCaged;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_MOV_AFASTAMENTO_SEFIP", foreignKey=@ForeignKey(name="FK_AFASTAMENTO_COLAB_MOV_SEFIP"))
    public MovimentoSefip getAfastamentoSefip() {
        return this.afastamentoSefip;
    }

    public void setAfastamentoSefip(MovimentoSefip afastamentoSefip) {
        this.afastamentoSefip = afastamentoSefip;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_AFASTAMENTO")
    public Date getDataAfastamento() {
        return this.dataAfastamento;
    }

    public void setDataAfastamento(Date dataAfastamento) {
        this.dataAfastamento = dataAfastamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_RETORNO")
    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_MOV_RETORNO_SEFIP", foreignKey=@ForeignKey(name="FK_AFASTAMENTO_COLAB_MOV_RE_SEF"))
    public MovimentoSefip getRetornoSefip() {
        return this.retornoSefip;
    }

    public void setRetornoSefip(MovimentoSefip retornoSefip) {
        this.retornoSefip = retornoSefip;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_AFASTAMENTO_COLAB_COLAB"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_AFASTAMENTO_RAIS", foreignKey=@ForeignKey(name="FK_AFASTAMENTO_COLAB_AFAST_RAIS"))
    public AfastamentoRais getAfastamentoRais() {
        return this.afastamentoRais;
    }

    public void setAfastamentoRais(AfastamentoRais afastamentoRais) {
        this.afastamentoRais = afastamentoRais;
    }

    @Column(name="DATA_ESTABILIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEstabilidade() {
        return this.dataEstabilidade;
    }

    public void setDataEstabilidade(Date dataEstabilidade) {
        this.dataEstabilidade = dataEstabilidade;
    }

    @Column(name="RECOLHER_FGTS")
    public Short getRecolherFgts() {
        return this.recolherFgts;
    }

    public void setRecolherFgts(Short recolherFgts) {
        this.recolherFgts = recolherFgts;
    }

    @Column(nullable=false, name="BASE_CALCULO_PAGAMENTO", precision=15, scale=2)
    public Double getBaseCalculoPagamento() {
        return this.baseCalculoPagamento;
    }

    public void setBaseCalculoPagamento(Double baseCalculoPagamento) {
        this.baseCalculoPagamento = baseCalculoPagamento;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="afastamentoColaborador", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<MediaAfastamentoColaborador> getMediaAfastamento() {
        return this.mediaAfastamento;
    }

    public void setMediaAfastamento(List<MediaAfastamentoColaborador> mediaAfastamento) {
        this.mediaAfastamento = mediaAfastamento;
    }

    @Column(nullable=false, name="SALARIO_NORMINAL", precision=15, scale=2)
    public Double getSalarioNominal() {
        return this.salarioNominal;
    }

    public void setSalarioNominal(Double salarioNominal) {
        this.salarioNominal = salarioNominal;
    }

    @Column(nullable=false, name="VALOR_MEDIAS", precision=15, scale=2)
    public Double getValorMedias() {
        return this.valorMedias;
    }

    public void setValorMedias(Double valorMedias) {
        this.valorMedias = valorMedias;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ESOC_MOT_AFASTAMENTO", foreignKey=@ForeignKey(name="FK_AFAST_COLAB_ESOC_MOT"))
    public EsocMotivoAfastamento getEsocMotivoAfastamento() {
        return this.esocMotivoAfastamento;
    }

    public void setEsocMotivoAfastamento(EsocMotivoAfastamento esocMotivoAfastamento) {
        this.esocMotivoAfastamento = esocMotivoAfastamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="INFO_MESMO_MOTIVO")
    public Short getInfoMesmoMotivo() {
        return this.infoMesmoMotivo;
    }

    public void setInfoMesmoMotivo(Short infoMesmoMotivo) {
        this.infoMesmoMotivo = infoMesmoMotivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_TIPO_ACID_TRAB", foreignKey=@ForeignKey(name="FK_AFAST_ESOC_TIPO_ACID_TRAB"))
    public EsocTipoAcidenteTrabalho getEsocTipoAcidente() {
        return this.esocTipoAcidente;
    }

    public void setEsocTipoAcidente(EsocTipoAcidenteTrabalho esocTipoAcidente) {
        this.esocTipoAcidente = esocTipoAcidente;
    }

    @Column(name="CODIGO_CID", length=15)
    public String getCodigoCid() {
        return this.codigoCid;
    }

    public void setCodigoCid(String codigoCid) {
        this.codigoCid = codigoCid;
    }

    @Column(name="QTDADE_DIAS_CONCEDIDOS")
    public Integer getQtdadeDiasConcedidos() {
        return this.qtdadeDiasConcedidos;
    }

    public void setQtdadeDiasConcedidos(Integer qtdadeDiasConcedidos) {
        this.qtdadeDiasConcedidos = qtdadeDiasConcedidos;
    }

    @Column(name="ORGAO_CLASSE", length=100)
    public String getOrgaoClasse() {
        return this.orgaoClasse;
    }

    public void setOrgaoClasse(String orgaoClasse) {
        this.orgaoClasse = orgaoClasse;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FEDERATIVA_CLASSE", foreignKey=@ForeignKey(name="FK_AFAST_ATEST_UF_O_CLASSE"))
    public UnidadeFederativa getEstadoOrgaoClasse() {
        return this.estadoOrgaoClasse;
    }

    public void setEstadoOrgaoClasse(UnidadeFederativa estadoOrgaoClasse) {
        this.estadoOrgaoClasse = estadoOrgaoClasse;
    }

    @Column(name="MEDIDO", length=100)
    public String getMedico() {
        return this.medico;
    }

    public void setMedico(String medico) {
        this.medico = medico;
    }

    @Column(name="TIPO_ORGAO")
    public Short getTipoOrgao() {
        return this.tipoOrgao;
    }

    public void setTipoOrgao(Short tipoOrgao) {
        this.tipoOrgao = tipoOrgao;
    }

    @Override
    @OneToMany(mappedBy="afastamentoColaborador")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Column(name="INFORMAR_DATA_MANUAL")
    public Short getInformarDataManual() {
        return this.informarDataManual;
    }

    public void setInformarDataManual(Short informarDataManual) {
        this.informarDataManual = informarDataManual;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="OBSERVACAO", length=100)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_LICENCA", foreignKey=@ForeignKey(name="FK_TP_CALCULO_EVENTO_LICENCA"))
    public TipoCalculoEvento getEventoLicenca() {
        return this.eventoLicenca;
    }

    public void setEventoLicenca(TipoCalculoEvento eventoLicenca) {
        this.eventoLicenca = eventoLicenca;
    }

    @Column(name="ATESTADO_POR_COVID")
    public Short getAtestadoPorCovid() {
        return this.atestadoPorCovid;
    }

    public void setAtestadoPorCovid(Short atestadoPorCovid) {
        this.atestadoPorCovid = atestadoPorCovid;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_AFAST_COLAB_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="atestado_seguido_afastamento")
    public Short getAtestadoSeguidoAfastamento() {
        return this.atestadoSeguidoAfastamento;
    }

    public void setAtestadoSeguidoAfastamento(Short atestadoSeguidoAfastamento) {
        this.atestadoSeguidoAfastamento = atestadoSeguidoAfastamento;
    }

    @Column(name="periodo_inicial_media")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoInicialMedia() {
        return this.periodoInicialMedia;
    }

    public void setPeriodoInicialMedia(Date periodoInicialMedia) {
        this.periodoInicialMedia = periodoInicialMedia;
    }

    @Column(name="periodo_final_media")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoFinalMedia() {
        return this.periodoFinalMedia;
    }

    public void setPeriodoFinalMedia(Date periodoFinalMedia) {
        this.periodoFinalMedia = periodoFinalMedia;
    }
}

