/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.alteracaoestoqueterceiros.EnumConstTipoMovAltEstTerc;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ALTERACAO_EST_TERC")
public class AlteracaoEstoqueTerceiros
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Usuario usuario;
    private String motivo;
    private EstoqueTerceiros estoqueTerceiros;
    private Short desvincularEstoqueNotaMae = EnumConstantsMentorSimNao.NAO.getValue();
    private Double qtdeEstTercMae = 0.0;
    private Double qtdeEstTercFilho = 0.0;
    private Double qtdeSaldoMaeFilho = 0.0;
    private Double qtdeInativada = 0.0;
    private Short tipoMovimento = EnumConstTipoMovAltEstTerc.MOVIMENTO_INATIVO_TOTAL.getValue();

    @Id
    @Column(nullable=false, name="ID_ALTERACAO_EST_TERC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ALTERACAO_EST_TERC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ALTERACAO_EST_TERC_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_ALTERACAO_EST_TERC_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="MOTIVO", length=500)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_ESTOQUE_TERCEIROS", foreignKey=@ForeignKey(name="FK_ALTERACAO_EST_TERC_EST_TERC"))
    public EstoqueTerceiros getEstoqueTerceiros() {
        return this.estoqueTerceiros;
    }

    public void setEstoqueTerceiros(EstoqueTerceiros estoqueTerceiros) {
        this.estoqueTerceiros = estoqueTerceiros;
    }

    @Column(name="DESV_ESTOQUE_NOTA_MAE")
    public Short getDesvincularEstoqueNotaMae() {
        return this.desvincularEstoqueNotaMae;
    }

    public void setDesvincularEstoqueNotaMae(Short desvincularEstoqueNotaMae) {
        this.desvincularEstoqueNotaMae = desvincularEstoqueNotaMae;
    }

    @Column(name="QTDE_EST_TERC_MAE", precision=15, scale=6)
    public Double getQtdeEstTercMae() {
        return this.qtdeEstTercMae;
    }

    public void setQtdeEstTercMae(Double qtdeEstTercMae) {
        this.qtdeEstTercMae = qtdeEstTercMae;
    }

    @Column(name="QTDE_EST_TERC_FILHO", precision=15, scale=6)
    public Double getQtdeEstTercFilho() {
        return this.qtdeEstTercFilho;
    }

    public void setQtdeEstTercFilho(Double qtdeEstTercFilho) {
        this.qtdeEstTercFilho = qtdeEstTercFilho;
    }

    @Column(name="QTDE_SALDO_MAE_FILHO", precision=15, scale=6)
    public Double getQtdeSaldoMaeFilho() {
        return this.qtdeSaldoMaeFilho;
    }

    public void setQtdeSaldoMaeFilho(Double qtdeSaldoMaeFilho) {
        this.qtdeSaldoMaeFilho = qtdeSaldoMaeFilho;
    }

    @Column(name="QTDE_INATIVADA", precision=15, scale=6)
    public Double getQtdeInativada() {
        return this.qtdeInativada;
    }

    public void setQtdeInativada(Double qtdeInativada) {
        this.qtdeInativada = qtdeInativada;
    }

    @Column(name="TIPO_MOVIMENTO")
    public Short getTipoMovimento() {
        return this.tipoMovimento;
    }

    public void setTipoMovimento(Short tipoMovimento) {
        this.tipoMovimento = tipoMovimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getEmpresa() != null ? this.getEmpresa().getPessoa() : this.getEmpresa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

