/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdEnc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ANALISE_PR_VENDA_PROD", uniqueConstraints={@UniqueConstraint(name="UNQ1_ANALISE_PR_VENDA_PROD", columnNames={"ID_TAB_PR_BASE_PROD"})})
public class AnalisePrVendaProd
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Produto produto;
    private String descricao;
    private GradeCor gradeCor;
    private String observacao;
    private List<AnalisePrVendaProdCen> cenarios = new ArrayList<AnalisePrVendaProdCen>();
    private Double toleranciaPrecoAbaixo = 0.0;
    private Double toleranciaPrecoAcima = 0.0;
    private TabelaPrecoBaseProduto tabelaPrecoBaseProduto;
    private PreTabelaPrecoBaseProduto preTabelaPrecoBaseProduto;
    private Empresa empresa;
    private AnalisePrVendaProdEnc analisePrVendaPCPEnc;
    private List<AnalisePrVendaProd> analises = new ArrayList<AnalisePrVendaProd>();
    private AnalisePrVendaProd analisePai;
    private Double valorTotal = 0.0;
    private Short escolhido = EnumConstantsMentorSimNao.NAO.getValue();
    private Double quantidade = 1.0;

    @Id
    @Column(nullable=false, name="ID_ANALISE_PR_VENDA_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ANALISE_PR_VENDA_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ANALISE_PR_VENDA_PROD_PROD"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="analisePrVendaProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnalisePrVendaProdCen> getCenarios() {
        return this.cenarios;
    }

    public void setCenarios(List<AnalisePrVendaProdCen> cenarios) {
        this.cenarios = cenarios;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"An\u00e1lise {0} - Produto {1}", (Object[])new Object[]{this.getIdentificador(), this.getProduto()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TAB_PR_BASE_PROD", foreignKey=@ForeignKey(name="FK_AN_PR_VENDA_PR_PROD_BASE_PR"))
    public TabelaPrecoBaseProduto getTabelaPrecoBaseProduto() {
        return this.tabelaPrecoBaseProduto;
    }

    public void setTabelaPrecoBaseProduto(TabelaPrecoBaseProduto tabelaPrecoBaseProduto) {
        this.tabelaPrecoBaseProduto = tabelaPrecoBaseProduto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_AN_PR_VENDA_PR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="TOLERANCIA_PRECO_ABAIXO", precision=15, scale=2)
    public Double getToleranciaPrecoAbaixo() {
        return this.toleranciaPrecoAbaixo;
    }

    public void setToleranciaPrecoAbaixo(Double toleranciaPrecoAbaixo) {
        this.toleranciaPrecoAbaixo = toleranciaPrecoAbaixo;
    }

    @Column(nullable=false, name="TOLERANCIA_PRECO_ACIMA", precision=15, scale=2)
    public Double getToleranciaPrecoAcima() {
        return this.toleranciaPrecoAcima;
    }

    public void setToleranciaPrecoAcima(Double toleranciaPrecoAcima) {
        this.toleranciaPrecoAcima = toleranciaPrecoAcima;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_ANALISE_PR_VENDA_PROD_ENC", foreignKey=@ForeignKey(name="FK_ANALISE_PR_VENDA_PROD_PCP"))
    public AnalisePrVendaProdEnc getAnalisePrVendaPCPEnc() {
        return this.analisePrVendaPCPEnc;
    }

    public void setAnalisePrVendaPCPEnc(AnalisePrVendaProdEnc analisePrVendaPCPEnc) {
        this.analisePrVendaPCPEnc = analisePrVendaPCPEnc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_ANALISE_PR_VENDA_PROD_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_TAB_PR_BASE_PROD", foreignKey=@ForeignKey(name="FK_AN_PR_VENDA_PRE_TAB_PR_PROD_PR"))
    public PreTabelaPrecoBaseProduto getPreTabelaPrecoBaseProduto() {
        return this.preTabelaPrecoBaseProduto;
    }

    public void setPreTabelaPrecoBaseProduto(PreTabelaPrecoBaseProduto preTabelaPrecoBaseProduto) {
        this.preTabelaPrecoBaseProduto = preTabelaPrecoBaseProduto;
    }

    @OneToMany(mappedBy="analisePai")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnalisePrVendaProd> getAnalises() {
        return this.analises;
    }

    public void setAnalises(List<AnalisePrVendaProd> analises) {
        this.analises = analises;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ANALISE_PAI_PR_VENDA", foreignKey=@ForeignKey(name="FK_SUB_ANA_PR_VENDA_PAI"))
    public AnalisePrVendaProd getAnalisePai() {
        return this.analisePai;
    }

    public void setAnalisePai(AnalisePrVendaProd analisePai) {
        this.analisePai = analisePai;
    }

    @Column(name="VALOR_TOTAL", precision=12, scale=4)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(name="ESCOLHIDO")
    public Short getEscolhido() {
        return this.escolhido;
    }

    public void setEscolhido(Short escolhido) {
        this.escolhido = escolhido;
    }

    @Column(name="QUANTIDADE", precision=12, scale=4)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }
}

