/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.ItemApontamentoLocacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="APONT_LOCACAO_EQUIPAMENTO")
public class ApontamentoLocacaoEquipamento
implements InterfaceVO {
    @Id
    @Column(name="ID_APONT_LOCACAO_EQUIPAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APONT_LOCACAO_EQUIPAMENTO")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    private Date dataCadastro;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APONT_LOCACAO_EQUIP_EMPRESA"))
    private Empresa empresa;
    @Version
    @Column(name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @Column(name="CODIGO", length=100)
    private String codigo;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    private Date dataEmissao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_APONT_LOCACAO_EQUIP_EQUIP"))
    private Equipamento equipamento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OPERADOR", foreignKey=@ForeignKey(name="FK_APONT_LOCACAO_EQUIP_PESSOA"))
    private Pessoa operador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_APONT_LOCACAO_EQUIP_CLIENTE"))
    private Cliente cliente;
    @Column(name="OBSERVACAO", length=5000)
    private String observacao;
    @OneToMany(mappedBy="apontamentoLocacaoEquipamento", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<ItemApontamentoLocacao> apontamentos = new ArrayList<ItemApontamentoLocacao>();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getCodigo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public Equipamento getEquipamento() {
        return this.equipamento;
    }

    @Generated
    public Pessoa getOperador() {
        return this.operador;
    }

    @Generated
    public Cliente getCliente() {
        return this.cliente;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<ItemApontamentoLocacao> getApontamentos() {
        return this.apontamentos;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setEquipamento(Equipamento equipamento) {
        this.equipamento = equipamento;
    }

    @Generated
    public void setOperador(Pessoa operador) {
        this.operador = operador;
    }

    @Generated
    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setApontamentos(List<ItemApontamentoLocacao> apontamentos) {
        this.apontamentos = apontamentos;
    }
}

