/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.dctf.EnumConstPeriodicidadeDCTF;
import com.touchcomp.basementor.constants.enums.dctf.EnumConstTipoApuracaoLucroRealDCTF;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoCSLLPresumido;
import com.touchcomp.basementor.model.vo.ApuracaoCSLLReal;
import com.touchcomp.basementor.model.vo.ApuracaoIRPJPresumido;
import com.touchcomp.basementor.model.vo.ApuracaoIRPJReal;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APUR_CSLL_IRPJ")
public class ApuracaoCSLLIRPJ
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataInicial;
    private Date dataFinal;
    private Short tipoRegime = 0;
    private Short tipoApuracao;
    private Short abaterIPI = 1;
    private Short abaterIcmsST = 1;
    private Short calcularValorRetidoFonte = 1;
    private Short tipoApuracaoLucroReal;
    private List<ApuracaoCSLLPresumido> apuracaoCSLLPresumido = new ArrayList<ApuracaoCSLLPresumido>();
    private List<ApuracaoIRPJPresumido> apuracaoIRPJPresumido = new ArrayList<ApuracaoIRPJPresumido>();
    private List<ApuracaoCSLLReal> apuracaoCSLLReal = new ArrayList<ApuracaoCSLLReal>();
    private List<ApuracaoIRPJReal> apuracaoIRPJReal = new ArrayList<ApuracaoIRPJReal>();
    private EncerramentoContabil encerramentoContabil;

    public ApuracaoCSLLIRPJ() {
        this.tipoApuracao = EnumConstPeriodicidadeDCTF.MENSAL.getValue();
        this.tipoApuracaoLucroReal = EnumConstTipoApuracaoLucroRealDCTF.ESTIMATIVA.getValue();
    }

    @Id
    @Column(name="ID_APUR_CSLL_IRPJ")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APUR_CSLL_IRPJ")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APUR_CSLL_IRPJ_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="apuracaoCSLLIRPJ", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoCSLLPresumido> getApuracaoCSLLPresumido() {
        return this.apuracaoCSLLPresumido;
    }

    public void setApuracaoCSLLPresumido(List<ApuracaoCSLLPresumido> apuracaoCSLLPresumido) {
        this.apuracaoCSLLPresumido = apuracaoCSLLPresumido;
    }

    @Column(nullable=false, name="TIPO_REGIME")
    public Short getTipoRegime() {
        return this.tipoRegime;
    }

    public void setTipoRegime(Short tipoRegime) {
        this.tipoRegime = tipoRegime;
    }

    @OneToMany(mappedBy="apuracaoCSLLIRPJ", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoIRPJPresumido> getApuracaoIRPJPresumido() {
        return this.apuracaoIRPJPresumido;
    }

    public void setApuracaoIRPJPresumido(List<ApuracaoIRPJPresumido> apuracaoIRPJPresumido) {
        this.apuracaoIRPJPresumido = apuracaoIRPJPresumido;
    }

    @Column(name="TIPO_APURACAO")
    public Short getTipoApuracao() {
        return this.tipoApuracao;
    }

    public void setTipoApuracao(Short tipoApuracao) {
        this.tipoApuracao = tipoApuracao;
    }

    @Column(name="ABATER_IPI")
    public Short getAbaterIPI() {
        return this.abaterIPI;
    }

    public void setAbaterIPI(Short abaterIPI) {
        this.abaterIPI = abaterIPI;
    }

    @Column(name="ABATER_ICMS_ST")
    public Short getAbaterIcmsST() {
        return this.abaterIcmsST;
    }

    public void setAbaterIcmsST(Short abaterIcmsST) {
        this.abaterIcmsST = abaterIcmsST;
    }

    @Column(name="CALCULAR_VR_RETIDO_FONTE")
    public Short getCalcularValorRetidoFonte() {
        return this.calcularValorRetidoFonte;
    }

    public void setCalcularValorRetidoFonte(Short calcularValorRetidoFonte) {
        this.calcularValorRetidoFonte = calcularValorRetidoFonte;
    }

    @Column(name="TIPO_APURACAO_LUCRO_REAL")
    public Short getTipoApuracaoLucroReal() {
        return this.tipoApuracaoLucroReal;
    }

    public void setTipoApuracaoLucroReal(Short tipoApuracaoLucroReal) {
        this.tipoApuracaoLucroReal = tipoApuracaoLucroReal;
    }

    @OneToMany(mappedBy="apuracaoCSLLIRPJ", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoCSLLReal> getApuracaoCSLLReal() {
        return this.apuracaoCSLLReal;
    }

    public void setApuracaoCSLLReal(List<ApuracaoCSLLReal> apuracaoCSLLReal) {
        this.apuracaoCSLLReal = apuracaoCSLLReal;
    }

    @OneToMany(mappedBy="apuracaoCSLLIRPJ", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoIRPJReal> getApuracaoIRPJReal() {
        return this.apuracaoIRPJReal;
    }

    public void setApuracaoIRPJReal(List<ApuracaoIRPJReal> apuracaoIRPJReal) {
        this.apuracaoIRPJReal = apuracaoIRPJReal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ENCERRAMENTO_CONTABIL", foreignKey=@ForeignKey(name="FK_APUR_CSLL_IRPJ_ENC_CONTABIL"))
    public EncerramentoContabil getEncerramentoContabil() {
        return this.encerramentoContabil;
    }

    public void setEncerramentoContabil(EncerramentoContabil encerramentoContabil) {
        this.encerramentoContabil = encerramentoContabil;
    }
}

