/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AjusteApuracaoIcms;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemObrigIcmsRecolher;
import com.touchcomp.basementor.model.vo.SubApuracaoICMS;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.ValoresDecAPIcms;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="APURACAO_ICMS", uniqueConstraints={@UniqueConstraint(name="UNQ1_APURACAO_ICMS", columnNames={"ANO_MES", "TIPO_APURACAO", "ICMS_IPI", "ID_EMPRESA", "ID_UNIDADE_FEDERATIVA"})})
public class ApuracaoICMS
implements InterfaceVO {
    private Long identificador;
    private Date anoMes;
    private Double vrDebito = 0.0;
    private Double vrOutroDebito = 0.0;
    private Double vrEstornoCredito = 0.0;
    private Double vrCredito = 0.0;
    private Double vrOutroCredito = 0.0;
    private Double vrEstornoDebito = 0.0;
    private Double vrRessarcimentoST = 0.0;
    private Double vrDeducoes = 0.0;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Double saldoDevedor = 0.0;
    private Double saldoCredor = 0.0;
    private Double saldoCredorAnterior = 0.0;
    private Short tipoApuracao = 0;
    private Short icmsIpi = 0;
    private String observacoes;
    private List<AjusteApuracaoIcms> ajustesApuracao = new ArrayList<AjusteApuracaoIcms>();
    private List<ValoresDecAPIcms> valoresDeclaratorios = new ArrayList<ValoresDecAPIcms>();
    private List<ItemObrigIcmsRecolher> itensObrigIcms = new ArrayList<ItemObrigIcmsRecolher>();
    private Double vrIcmsStDevolucao = 0.0;
    private Double debEspecial = 0.0;
    private Double percCredPresumidoFreteST = 0.0;
    private UnidadeFederativa unidadeFederativa;
    private Double valorAjusteDebito = 0.0;
    private Double valorAjusteCredito = 0.0;
    private Double saldoCredorAntOutSis = 0.0;
    private Double valorIcmsRecolher = 0.0;
    private List<SubApuracaoICMS> subApuracao = new ArrayList<SubApuracaoICMS>();

    @Id
    @Column(name="ID_APURACAO_ICMS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APURACAO_ICMS")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="ANO_MES")
    @Temporal(value=TemporalType.DATE)
    public Date getAnoMes() {
        return this.anoMes;
    }

    @Column(nullable=false, name="VR_DEBITO", precision=12, scale=2)
    public Double getVrDebito() {
        return this.vrDebito;
    }

    @Column(nullable=false, name="VR_OUTRO_DEBITO", precision=12, scale=2)
    public Double getVrOutroDebito() {
        return this.vrOutroDebito;
    }

    @Column(nullable=false, name="VR_ESTORNO_CREDITO", precision=12, scale=2)
    public Double getVrEstornoCredito() {
        return this.vrEstornoCredito;
    }

    @Column(nullable=false, name="VR_CREDITO", precision=12, scale=2)
    public Double getVrCredito() {
        return this.vrCredito;
    }

    @Column(nullable=false, name="VR_OUTRO_CREDITO", precision=12, scale=2)
    public Double getVrOutroCredito() {
        return this.vrOutroCredito;
    }

    @Column(nullable=false, name="VR_ESTORNO_DEBITO", precision=12, scale=2)
    public Double getVrEstornoDebito() {
        return this.vrEstornoDebito;
    }

    @Column(nullable=false, name="VR_DEDUCOES", precision=12, scale=2)
    public Double getVrDeducoes() {
        return this.vrDeducoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APURACAO_ICMS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(nullable=false, name="SALDO_DEVEDOR", precision=12, scale=2)
    public Double getSaldoDevedor() {
        return this.saldoDevedor;
    }

    @Column(nullable=false, name="SALDO_CREDOR", precision=12, scale=2)
    public Double getSaldoCredor() {
        return this.saldoCredor;
    }

    @Column(name="TIPO_APURACAO")
    public Short getTipoApuracao() {
        return this.tipoApuracao;
    }

    @Column(name="ICMS_IPI")
    public Short getIcmsIpi() {
        return this.icmsIpi;
    }

    @Column(nullable=false, name="SALDO_CREDOR_ANTERIOR", precision=12, scale=2)
    public Double getSaldoCredorAnterior() {
        return this.saldoCredorAnterior;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setAnoMes(Date anoMes) {
        this.anoMes = anoMes;
    }

    public void setVrDebito(Double vrDebito) {
        this.vrDebito = vrDebito;
    }

    public void setVrOutroDebito(Double vrOutroDebito) {
        this.vrOutroDebito = vrOutroDebito;
    }

    public void setVrEstornoCredito(Double vrEstornoCredito) {
        this.vrEstornoCredito = vrEstornoCredito;
    }

    public void setVrCredito(Double vrCredito) {
        this.vrCredito = vrCredito;
    }

    public void setVrOutroCredito(Double vrOutroCredito) {
        this.vrOutroCredito = vrOutroCredito;
    }

    public void setVrEstornoDebito(Double vrEstornoDebito) {
        this.vrEstornoDebito = vrEstornoDebito;
    }

    public void setVrDeducoes(Double vrDeducoes) {
        this.vrDeducoes = vrDeducoes;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setSaldoDevedor(Double saldoDevedor) {
        this.saldoDevedor = saldoDevedor;
    }

    public void setSaldoCredor(Double saldoCredor) {
        this.saldoCredor = saldoCredor;
    }

    public void setTipoApuracao(Short tipoApuracao) {
        this.tipoApuracao = tipoApuracao;
    }

    public void setIcmsIpi(Short icmsIpi) {
        this.icmsIpi = icmsIpi;
    }

    public void setSaldoCredorAnterior(Double saldoCredorAnterior) {
        this.saldoCredorAnterior = saldoCredorAnterior;
    }

    @Column(name="OBSERVACOES", length=1000)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @OneToMany(mappedBy="apuracaoIcms", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<AjusteApuracaoIcms> getAjustesApuracao() {
        return this.ajustesApuracao;
    }

    public void setAjustesApuracao(List<AjusteApuracaoIcms> ajustesApuracao) {
        this.ajustesApuracao = ajustesApuracao;
    }

    @OneToMany(mappedBy="apuracaoIcms", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ValoresDecAPIcms> getValoresDeclaratorios() {
        return this.valoresDeclaratorios;
    }

    public void setValoresDeclaratorios(List<ValoresDecAPIcms> valoresDeclaratorios) {
        this.valoresDeclaratorios = valoresDeclaratorios;
    }

    @OneToMany(mappedBy="apuracaoIcms", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemObrigIcmsRecolher> getItensObrigIcms() {
        return this.itensObrigIcms;
    }

    public void setItensObrigIcms(List<ItemObrigIcmsRecolher> itensObrigIcms) {
        this.itensObrigIcms = itensObrigIcms;
    }

    @Column(nullable=false, name="VR_ICMS_ST_DEV", precision=12, scale=2)
    public Double getVrIcmsStDevolucao() {
        return this.vrIcmsStDevolucao;
    }

    public void setVrIcmsStDevolucao(Double vrIcmsStDevolucao) {
        this.vrIcmsStDevolucao = vrIcmsStDevolucao;
    }

    @Column(nullable=false, name="DEBITO_ESPECIAL", precision=12, scale=2)
    public Double getDebEspecial() {
        return this.debEspecial;
    }

    public void setDebEspecial(Double debEspecial) {
        this.debEspecial = debEspecial;
    }

    @JoinColumn(name="ID_UNIDADE_FEDERATIVA", foreignKey=@ForeignKey(name="FK_APURACAO_ICMS_UF"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnidadeFederativa getUnidadeFederativa() {
        return this.unidadeFederativa;
    }

    public void setUnidadeFederativa(UnidadeFederativa unidadeFederativa) {
        this.unidadeFederativa = unidadeFederativa;
    }

    @Column(nullable=false, name="VR_RESSARCIMENTO_ST", precision=15, scale=2)
    public Double getVrRessarcimentoST() {
        return this.vrRessarcimentoST;
    }

    public void setVrRessarcimentoST(Double vrRessarcimentoST) {
        this.vrRessarcimentoST = vrRessarcimentoST;
    }

    @Column(nullable=false, name="PERC_CRED_PRES_FRETEST", precision=15, scale=2)
    public Double getPercCredPresumidoFreteST() {
        return this.percCredPresumidoFreteST;
    }

    public void setPercCredPresumidoFreteST(Double percCredPresumidoFreteST) {
        this.percCredPresumidoFreteST = percCredPresumidoFreteST;
    }

    @Column(nullable=false, name="VALOR_AJUSTE_DEBITO", precision=15, scale=2)
    public Double getValorAjusteDebito() {
        return this.valorAjusteDebito;
    }

    public void setValorAjusteDebito(Double valorAjusteDebito) {
        this.valorAjusteDebito = valorAjusteDebito;
    }

    @Column(nullable=false, name="VALOR_AJUSTE_CREDITO", precision=15, scale=2)
    public Double getValorAjusteCredito() {
        return this.valorAjusteCredito;
    }

    public void setValorAjusteCredito(Double valorAjusteCredito) {
        this.valorAjusteCredito = valorAjusteCredito;
    }

    @Column(nullable=false, name="SALDO_CREDO_ANT_OUT_SIS", precision=15, scale=2)
    public Double getSaldoCredorAntOutSis() {
        return this.saldoCredorAntOutSis;
    }

    public void setSaldoCredorAntOutSis(Double saldoCredorAntOutSis) {
        this.saldoCredorAntOutSis = saldoCredorAntOutSis;
    }

    @Column(nullable=false, name="VALOR_ICMS_RECOLHER", precision=15, scale=2)
    public Double getValorIcmsRecolher() {
        return this.valorIcmsRecolher;
    }

    public void setValorIcmsRecolher(Double valorIcmsRecolher) {
        this.valorIcmsRecolher = valorIcmsRecolher;
    }

    @OneToMany(mappedBy="apuracaoICMS", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<SubApuracaoICMS> getSubApuracao() {
        return this.subApuracao;
    }

    public void setSubApuracao(List<SubApuracaoICMS> subApuracao) {
        this.subApuracao = subApuracao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} {2}", (Object[])new Object[]{this.getIdentificador(), this.getEmpresa() != null ? this.getEmpresa().getPessoa().getNome() : this.getEmpresa(), this.getAnoMes()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

