/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APUR_TITULOS_CARTAO_CRED_DEB")
public class ApuracaoTitulosCartaoDebCred
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataApuracao;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private Usuario usuario;
    private Short filtrarCartaoDebito = 1;
    private Short filtrarCartaoCredito = 1;
    private Short filtrarCartaoAlimentacao = 1;
    private Short filtrarCartaoRefeicao = 1;
    private Short filtrarCartaoCombustivel = 1;

    @Id
    @Column(name="ID_APUR_TITULOS_CARTAO_CRED_DEB")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APUR_TITULO_CARTAO_CRED_DEB")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APUR_TIT_CAR_CRED_DEB_EMPRES"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_APURACAO")
    public Date getDataApuracao() {
        return this.dataApuracao;
    }

    public void setDataApuracao(Date dataApuracao) {
        this.dataApuracao = dataApuracao;
    }

    @OneToMany(mappedBy="apuracaoTitulosCartaoDebCred", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_APUR_TIT_CAR_CRED_DEB_USUARI"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getDataApuracao(), this.getEmpresa() != null ? this.getEmpresa().toString() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="filtrar_cartao_debito")
    public Short getFiltrarCartaoDebito() {
        return this.filtrarCartaoDebito;
    }

    public void setFiltrarCartaoDebito(Short filtrarCartaoDebito) {
        this.filtrarCartaoDebito = filtrarCartaoDebito;
    }

    @Column(name="filtrar_cartao_credito")
    public Short getFiltrarCartaoCredito() {
        return this.filtrarCartaoCredito;
    }

    public void setFiltrarCartaoCredito(Short filtrarCartaoCredito) {
        this.filtrarCartaoCredito = filtrarCartaoCredito;
    }

    @Column(name="filtrar_cartao_alimentacao")
    public Short getFiltrarCartaoAlimentacao() {
        return this.filtrarCartaoAlimentacao;
    }

    public void setFiltrarCartaoAlimentacao(Short filtrarCartaoAlimentacao) {
        this.filtrarCartaoAlimentacao = filtrarCartaoAlimentacao;
    }

    @Column(name="filtrar_cartao_refeicao")
    public Short getFiltrarCartaoRefeicao() {
        return this.filtrarCartaoRefeicao;
    }

    public void setFiltrarCartaoRefeicao(Short filtrarCartaoRefeicao) {
        this.filtrarCartaoRefeicao = filtrarCartaoRefeicao;
    }

    @Column(name="filtrar_cartao_combustivel")
    public Short getFiltrarCartaoCombustivel() {
        return this.filtrarCartaoCombustivel;
    }

    public void setFiltrarCartaoCombustivel(Short filtrarCartaoCombustivel) {
        this.filtrarCartaoCombustivel = filtrarCartaoCombustivel;
    }
}

